/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.actions;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.ui.eclipse.datacollection.api.DciOpenHandler;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ShowLineChart
implements DciOpenHandler {
    private long uniqueId = 1000000000L;

    public boolean open(DciValue dci) {
        if (dci.getDcObjectType() != 1 || dci.getDataType() == 4) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.uniqueId);
        sb.append("&");
        sb.append(Integer.toString(dci instanceof SimpleDciValue ? 1 : 2));
        sb.append("@");
        sb.append(Long.toString(dci.getNodeId()));
        sb.append("@");
        sb.append(Long.toString(dci.getId()));
        sb.append("@");
        try {
            sb.append(URLEncoder.encode(dci.getDescription(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Messages.get();
            sb.append(Messages.ShowLineChart_DescriptionUnavailable);
        }
        sb.append("@");
        try {
            sb.append(URLEncoder.encode(dci.getName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            sb.append("<name unavailable>");
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            window.getActivePage().showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", sb.toString(), 1);
        }
        catch (Exception e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ShowLineChart_Error, (String)String.format(Messages.ShowLineChart_ErrorOpeningView, e.getLocalizedMessage()));
        }
        return true;
    }
}

