/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.Arrays;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.dashboard.widgets.ComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ObjectStatusChartConfig;

public class ObjectStatusChartElement
extends ComparisonChartElement {
    private ObjectStatusChartConfig config;

    public ObjectStatusChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = ObjectStatusChartConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new ObjectStatusChartConfig();
        }
        this.refreshInterval = this.config.getRefreshRate();
        this.chart = ChartFactory.createBarChart((Composite)this, (int)0);
        this.chart.setTitleVisible(true);
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setLegendPosition(this.config.getLegendPosition());
        this.chart.setLegendVisible(this.config.isShowLegend());
        this.chart.set3DModeEnabled(this.config.isShowIn3D());
        this.chart.setTransposed(this.config.isTransposed());
        this.chart.setTranslucent(this.config.isTranslucent());
        int i = 0;
        while (i <= ObjectStatus.UNKNOWN.getValue()) {
            this.chart.addParameter(new GraphItem(0L, 0L, 0, 0, StatusDisplayInfo.getStatusText((int)i), StatusDisplayInfo.getStatusText((int)i), "%s"), 0.0);
            this.chart.setPaletteEntry(i, new ChartColor(StatusDisplayInfo.getStatusColor((int)i).getRGB()));
            ++i;
        }
        this.chart.initializationComplete();
        this.startRefreshTimer();
    }

    @Override
    protected ChartDciConfig[] getDciList() {
        return null;
    }

    @Override
    protected void refreshData(ChartDciConfig[] dciList) {
        int[] objectCount = new int[6];
        Arrays.fill(objectCount, 0);
        AbstractObject root = this.session.findObjectById(this.config.getRootObject());
        if (root != null) {
            this.collectData(objectCount, root);
        }
        int i = 0;
        while (i < objectCount.length) {
            this.chart.updateParameter(i, (double)objectCount[i], false);
            ++i;
        }
        this.chart.refresh();
    }

    private void collectData(int[] objectCount, AbstractObject root) {
        for (AbstractObject o : root.getAllChilds(-1)) {
            if (o.getStatus().compareTo((Enum)ObjectStatus.UNKNOWN) > 0 || !this.filterObject(o)) continue;
            int n = o.getStatus().getValue();
            objectCount[n] = objectCount[n] + 1;
        }
    }

    private boolean filterObject(AbstractObject o) {
        int[] cf = this.config.getClassFilter();
        int i = 0;
        while (i < cf.length) {
            if (o.getObjectClass() == cf[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

