/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.netxms.client.objects.AbstractObject;

public abstract class ObjectTab
implements IPluginContribution {
    protected String pluginId;
    protected String id;
    private ViewPart viewPart;
    private CTabFolder tabFolder;
    private CTabItem tabItem;
    private Composite clientArea;
    private AbstractObject object;
    private String name;
    private int order;
    private ImageDescriptor icon;
    private Image tabImage;
    private String contextId;
    private IContextActivation context = null;

    public void configure(IConfigurationElement ce, ViewPart viewPart) {
        this.viewPart = viewPart;
        this.pluginId = ce.getContributor().getName();
        this.id = ce.getAttribute("id");
        if (this.id == null) {
            this.id = "no_id";
        }
        this.name = ce.getAttribute("name");
        if (this.name == null) {
            this.name = "<noname>";
        }
        this.contextId = ce.getAttribute("contextId");
        try {
            this.order = Integer.parseInt(ce.getAttribute("order"), 10);
        }
        catch (NumberFormatException numberFormatException) {
            this.order = Integer.MAX_VALUE;
        }
        String path = ce.getAttribute("icon");
        if (path != null) {
            this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)ce.getContributor().getName(), (String)path);
        }
    }

    public void create(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
        this.clientArea = new Composite((Composite)tabFolder, 0);
        this.clientArea.setLayout((Layout)new FillLayout());
        this.createTabContent(this.clientArea);
        this.clientArea.setVisible(false);
    }

    protected abstract void createTabContent(Composite var1);

    public void selected() {
        IContextService contextService;
        this.clientArea.moveAbove(null);
        try {
            this.clientArea.setFocus();
        }
        catch (RuntimeException runtimeException) {}
        if (this.contextId != null && !this.contextId.isEmpty() && (contextService = (IContextService)this.getViewPart().getSite().getService(IContextService.class)) != null) {
            this.context = contextService.activateContext(this.contextId);
        }
    }

    public void unselected() {
        if (this.context == null) {
            return;
        }
        IContextService contextService = (IContextService)this.getViewPart().getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.deactivateContext(this.context);
            this.context = null;
        }
    }

    public boolean showForObject(AbstractObject object) {
        return true;
    }

    public abstract void objectChanged(AbstractObject var1);

    public void changeObject(AbstractObject object) {
        this.object = object;
        this.objectChanged(object);
    }

    public void currentObjectUpdated(AbstractObject object) {
    }

    public void show() {
        if (this.tabItem == null) {
            int index = this.tabFolder.getItemCount();
            int i = 0;
            while (i < this.tabFolder.getItemCount()) {
                ObjectTab tab = (ObjectTab)this.tabFolder.getItem(i).getData();
                if (tab.getOrder() > this.order) {
                    index = i;
                    break;
                }
                ++i;
            }
            this.tabItem = new CTabItem(this.tabFolder, 0, index);
            this.tabItem.setText(this.name);
            if (this.icon != null) {
                this.tabImage = this.icon.createImage();
                this.tabItem.setImage(this.tabImage);
            }
            this.tabItem.setControl((Control)this.clientArea);
            this.tabItem.setData((Object)this);
            this.clientArea.setVisible(true);
        }
    }

    public String getName() {
        return this.name;
    }

    public void hide() {
        if (this.tabItem != null) {
            this.tabItem.setControl(null);
            try {
                this.tabItem.dispose();
            }
            catch (RuntimeException runtimeException) {}
            this.tabItem = null;
            if (this.tabImage != null) {
                this.tabImage.dispose();
                this.tabImage = null;
            }
            this.clientArea.setVisible(false);
        }
    }

    public final boolean isVisible() {
        return this.tabItem != null;
    }

    public final boolean isActive() {
        return this.tabItem != null && this.tabFolder.getSelection() == this.tabItem;
    }

    public AbstractObject getObject() {
        return this.object;
    }

    public int getOrder() {
        return this.order;
    }

    public ViewPart getViewPart() {
        return this.viewPart;
    }

    public void dispose() {
        if (this.tabImage != null) {
            this.tabImage.dispose();
            this.tabImage = null;
        }
    }

    protected Composite getClientArea() {
        return this.clientArea;
    }

    public void refresh() {
    }

    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    public String getLocalId() {
        return this.id;
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

