/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary;

import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.console.api.ConsoleLoginListener;
import org.netxms.ui.eclipse.imagelibrary.Messages;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;

public class LoginListener
implements ConsoleLoginListener {
    public void afterLogin(final NXCSession session, final Display display) {
        ImageProvider.createInstance(display, session);
        Messages.get();
        Job job = new Job(Messages.LoginListener_JobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ImageProvider.getInstance().syncMetaData();
                    session.addListener((SessionListener)new ImageLibraryListener(display, session));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private final class ImageLibraryListener
    implements SessionListener {
        private ImageLibraryListener(Display display, NXCSession session) {
        }

        public void notificationHandler(SessionNotification n) {
            if (n.getCode() == 11) {
                UUID guid = (UUID)n.getObject();
                ImageProvider imageProvider = ImageProvider.getInstance();
                imageProvider.invalidateImage(guid, n.getSubCode() == 202L);
            }
        }
    }
}

