/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum RackElementType {
    PATCH_PANEL(0),
    FILLER_PANEL(1),
    ORGANISER(2);

    private int value;
    private static Map<Integer, RackElementType> lookupTable;

    static {
        lookupTable = new HashMap<Integer, RackElementType>();
        RackElementType[] rackElementTypeArray = RackElementType.values();
        int n = rackElementTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RackElementType element = rackElementTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private RackElementType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RackElementType getByValue(int value) {
        RackElementType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)RackElementType.class.getName(), (String)("Unknown element " + value));
            return FILLER_PANEL;
        }
        return element;
    }
}

