/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.jobs;

import java.lang.reflect.InvocationTargetException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AuthenticationType;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.KeepAliveTimer;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.SourceProvider;
import org.netxms.ui.eclipse.console.TweakletManager;
import org.netxms.ui.eclipse.console.api.ConsoleLoginListener;
import org.netxms.ui.eclipse.console.api.SessionProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LoginJob
implements IRunnableWithProgress {
    private Display display;
    private String server;
    private String loginName;
    private boolean encryptSession;
    private boolean ignoreProtocolVersion;
    private AuthenticationType authMethod;
    private String password;
    private Certificate certificate;
    private Signature signature;

    public LoginJob(Display display, String server, String loginName, boolean encryptSession, boolean ignoreProtocolVersion) {
        this.display = display;
        this.server = server;
        this.loginName = loginName;
        this.encryptSession = encryptSession;
        this.ignoreProtocolVersion = ignoreProtocolVersion;
        this.authMethod = AuthenticationType.PASSWORD;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Messages.get();
        monitor.setTaskName(Messages.LoginJob_connecting);
        try {
            try {
                NXCSession session;
                block14: {
                    block13: {
                        String hostName;
                        int port = 4701;
                        String[] split = this.server.split(":");
                        if (split.length == 2) {
                            hostName = split[0];
                            try {
                                port = Integer.valueOf(split[1]);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            hostName = this.server;
                        }
                        session = this.createSession(hostName, port);
                        session.setClientLanguage(Locale.getDefault().getLanguage());
                        session.setClientInfo("nxmc/2.2.3");
                        session.setIgnoreProtocolVersion(this.ignoreProtocolVersion);
                        monitor.worked(1);
                        session.connect(new int[]{5});
                        monitor.worked(1);
                        session.login(this.authMethod, this.loginName, this.password, this.certificate, this.signature);
                        monitor.worked(1);
                        Messages.get();
                        monitor.setTaskName(Messages.LoginJob_sync_objects);
                        session.syncObjects();
                        monitor.worked(1);
                        Messages.get();
                        monitor.setTaskName(Messages.LoginJob_sync_users);
                        session.syncUserDatabase();
                        monitor.worked(1);
                        Messages.get();
                        monitor.setTaskName(Messages.LoginJob_sync_event_db);
                        try {
                            session.syncEventTemplates();
                        }
                        catch (NXCException e) {
                            if (e.getErrorCode() == 2) break block13;
                            throw e;
                        }
                    }
                    try {
                        session.syncAlarmCategories();
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 2) break block14;
                        throw e;
                    }
                }
                monitor.worked(1);
                Messages.get();
                monitor.setTaskName(Messages.LoginJob_subscribe);
                session.subscribe("Core.Alarms");
                monitor.worked(1);
                ConsoleSharedData.setSession(session);
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SourceProvider.getInstance().updateAccessRights(session.getUserSystemRights());
                    }
                });
                Messages.get();
                monitor.setTaskName(Messages.LoginJob_init_extensions);
                TweakletManager.postLogin(session);
                this.callLoginListeners(session);
                monitor.worked(1);
                new KeepAliveTimer(session).start();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.setTaskName("");
            monitor.done();
        }
    }

    private NXCSession createSession(String hostName, int port) {
        IConfigurationElement currentElement = null;
        int currentPriotity = 65536;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.sessionproviders");
        int i = 0;
        while (i < elements.length) {
            int priority = 65535;
            String value = elements[i].getAttribute("priority");
            if (value != null) {
                try {
                    priority = Integer.parseInt(value);
                    if (priority < 0 || priority > 65535) {
                        priority = 65535;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (priority < currentPriotity) {
                currentElement = elements[i];
                currentPriotity = priority;
            }
            ++i;
        }
        if (currentElement != null) {
            try {
                SessionProvider p = (SessionProvider)currentElement.createExecutableExtension("class");
                return p.createSession(hostName, port, this.encryptSession);
            }
            catch (CoreException coreException) {}
        }
        return new NXCSession(hostName, port, this.encryptSession);
    }

    private void callLoginListeners(NXCSession session) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.loginlisteners");
        int i = 0;
        while (i < elements.length) {
            try {
                ConsoleLoginListener listener = (ConsoleLoginListener)elements[i].createExecutableExtension("class");
                listener.afterLogin(session, this.display);
            }
            catch (CoreException e) {
                Activator.logError("Exception in login listener", e);
            }
            ++i;
        }
    }

    public void setPassword(String password) {
        this.password = password;
        this.authMethod = AuthenticationType.PASSWORD;
    }

    public void setCertificate(Certificate certificate, Signature signature) {
        this.certificate = certificate;
        this.signature = signature;
        this.authMethod = AuthenticationType.CERTIFICATE;
    }
}

