/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.constants.Severity;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.widgets.helpers.CellSelectionManager;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableContentProvider;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableItemComparator;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableLabelProvider;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableValueFilter;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public abstract class BaseTableValueViewer
extends Composite {
    protected NXCSession session;
    protected IViewPart viewPart;
    protected String configId;
    protected FilterText filterText;
    protected TableValueFilter filter;
    protected Table currentData = null;
    protected SortableTableViewer viewer;
    protected TableLabelProvider labelProvider;
    protected CLabel errorLabel;
    protected CellSelectionManager cellSelectionManager;
    protected Action actionUseMultipliers;
    protected Action actionShowFilter;

    public BaseTableValueViewer(Composite parent, int style, IViewPart viewPart, String configSubId) {
        super(parent, style);
        this.viewPart = viewPart;
        this.configId = this.buildConfigId(configSubId);
        this.session = ConsoleSharedData.getSession();
        this.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText((Composite)this, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseTableValueViewer.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                BaseTableValueViewer.this.enableFilter(false);
            }
        });
        this.viewer = new SortableTableViewer((Composite)this, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.labelProvider = new TableLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.filter = new TableValueFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.cellSelectionManager = new CellSelectionManager(this.viewer);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        final IDialogSettings ds = Activator.getDefault().getDialogSettings();
        this.labelProvider.setUseMultipliers(BaseTableValueViewer.getBoolean(ds, String.valueOf(this.configId) + ".useMultipliers", false));
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)BaseTableValueViewer.this.viewer, (IDialogSettings)ds, (String)BaseTableValueViewer.this.configId);
                ds.put(String.valueOf(BaseTableValueViewer.this.configId) + ".initShowfilter", BaseTableValueViewer.this.actionShowFilter.isChecked());
            }
        });
        this.createActions();
        this.createPopupMenu();
        if (BaseTableValueViewer.getBoolean(ds, String.valueOf(this.configId) + ".initShowfilter", false)) {
            this.filterText.setFocus();
            this.actionShowFilter.setChecked(true);
        } else {
            this.enableFilter(false);
        }
    }

    protected String buildConfigId(String configSubId) {
        return "BaseTableValueViewer." + configSubId;
    }

    protected void createActions() {
        this.actionUseMultipliers = new Action("Use &multipliers", 2){

            public void run() {
                BaseTableValueViewer.this.labelProvider.setUseMultipliers(BaseTableValueViewer.this.actionUseMultipliers.isChecked());
                BaseTableValueViewer.this.viewer.refresh(true);
            }
        };
        this.actionUseMultipliers.setChecked(this.labelProvider.areMultipliersUsed());
        this.actionShowFilter = new Action(){

            public void run() {
                BaseTableValueViewer.this.enableFilter(BaseTableValueViewer.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setText("Show filter");
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.perfview.commands.show_table_values_filter");
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                BaseTableValueViewer.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionUseMultipliers);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void updateViewer(Table table) {
        final IDialogSettings ds = Activator.getDefault().getDialogSettings();
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 150);
            this.viewer.createColumns(names, widths, 0, 128);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)this.configId);
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)BaseTableValueViewer.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)BaseTableValueViewer.this.configId);
                    ds.put(String.valueOf(BaseTableValueViewer.this.configId) + ".useMultipliers", BaseTableValueViewer.this.labelProvider.areMultipliersUsed());
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        this.labelProvider.setColumns(table.getColumns());
        this.viewer.setInput((Object)table);
        this.currentData = table;
    }

    protected String buildInstanceString(ViewerRow viewerRow) {
        StringBuilder instance = new StringBuilder();
        boolean first = true;
        int i = 0;
        while (i < this.currentData.getColumnCount()) {
            TableColumnDefinition cd = this.currentData.getColumnDefinition(i);
            if (cd.isInstanceColumn()) {
                if (!first) {
                    instance.append("~~~");
                }
                instance.append(viewerRow.getText(i));
                first = false;
            }
            ++i;
        }
        return instance.toString();
    }

    public String getTitle() {
        return this.currentData != null ? this.currentData.getTitle() : "";
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public Action getActionUseMultipliers() {
        return this.actionUseMultipliers;
    }

    public void enableFilter(boolean enable) {
        this.actionShowFilter.setChecked(enable);
        this.filterText.setVisible(enable);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    public String getFilterText() {
        return this.filterText.getText();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    public Action getShowFilterAction() {
        return this.actionShowFilter;
    }

    protected static boolean getBoolean(IDialogSettings ds, String s, boolean defval) {
        return ds.getBoolean(s) ? true : defval;
    }

    public void refresh(final Runnable postRefreshHook) {
        this.viewer.setInput(null);
        ConsoleJob job = new ConsoleJob(this.getReadJobName(), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = BaseTableValueViewer.this.readData();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).BaseTableValueViewer.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        if ((this).BaseTableValueViewer.this.errorLabel != null) {
                            (this).BaseTableValueViewer.this.errorLabel.dispose();
                            (this).BaseTableValueViewer.this.errorLabel = null;
                            (this).BaseTableValueViewer.this.viewer.getControl().setVisible(true);
                            (this).BaseTableValueViewer.this.viewer.getControl().getParent().layout(true, true);
                        }
                        BaseTableValueViewer.this.updateViewer(table);
                        if (postRefreshHook != null) {
                            postRefreshHook.run();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return BaseTableValueViewer.this.getReadJobErrorMessage();
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).BaseTableValueViewer.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        if ((this).BaseTableValueViewer.this.errorLabel == null) {
                            (this).BaseTableValueViewer.this.errorLabel = new CLabel((this).BaseTableValueViewer.this.viewer.getControl().getParent(), 0);
                            (this).BaseTableValueViewer.this.errorLabel.setFont(JFaceResources.getBannerFont());
                            (this).BaseTableValueViewer.this.errorLabel.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.CRITICAL));
                            (this).BaseTableValueViewer.this.errorLabel.moveAbove((this).BaseTableValueViewer.this.viewer.getControl());
                            FormData fd = new FormData();
                            fd.top = new FormAttachment(0, 0);
                            fd.left = new FormAttachment(0, 0);
                            fd.right = new FormAttachment(100, 0);
                            fd.bottom = new FormAttachment(100, 0);
                            (this).BaseTableValueViewer.this.errorLabel.setLayoutData((Object)fd);
                            (this).BaseTableValueViewer.this.viewer.getControl().getParent().layout(true, true);
                            (this).BaseTableValueViewer.this.viewer.getControl().setVisible(false);
                        }
                        (this).BaseTableValueViewer.this.errorLabel.setText(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    protected abstract Table readData() throws Exception;

    protected abstract String getReadJobName();

    protected abstract String getReadJobErrorMessage();
}

