/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.layout;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.dashboard.layout.DashboardLayoutData;

public class DashboardLayout
extends Layout {
    public int numColumns = 1;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    private static final int MAX_ROWS = 64;
    private int rowCount = 0;
    private Map<Control, Point> coordinates = new HashMap<Control, Point>(0);
    private int[] rowStart = null;
    private Point cachedSize = null;

    private int freeSpaceInRow(boolean[][] cellUsed, int row) {
        int i = this.numColumns - 1;
        while (i >= 0 && !cellUsed[row][i]) {
            --i;
        }
        return this.numColumns - i - 1;
    }

    private void createGrid(Composite parent) {
        Control[] children = parent.getChildren();
        this.coordinates = new HashMap<Control, Point>(children.length);
        boolean[][] cellUsed = new boolean[64][this.numColumns];
        int currentColumn = 0;
        int currentRow = 0;
        this.rowCount = 0;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.isVisible()) {
                DashboardLayoutData layoutData = DashboardLayout.getLayoutData(child);
                int columnSpan = layoutData.horizontalSpan;
                if (columnSpan > this.numColumns) {
                    throw new IllegalArgumentException("colSpan (" + columnSpan + ") > number of columns (" + this.numColumns + ")");
                }
                int freeSpace = 0;
                int j = currentColumn;
                while (j < this.numColumns && freeSpace < columnSpan) {
                    if (!cellUsed[currentRow][j]) {
                        ++freeSpace;
                    } else {
                        ++currentColumn;
                        freeSpace = 0;
                    }
                    ++j;
                }
                if (freeSpace < columnSpan) {
                    while (this.freeSpaceInRow(cellUsed, currentRow) < layoutData.horizontalSpan) {
                        ++currentRow;
                    }
                    currentColumn = 0;
                }
                int _c = 0;
                while (_c < columnSpan) {
                    int _r = 0;
                    while (_r < layoutData.verticalSpan) {
                        cellUsed[currentRow + _r][currentColumn + _c] = true;
                        ++_r;
                    }
                    ++_c;
                }
                this.coordinates.put(child, new Point(currentColumn, currentRow));
                this.rowCount = Math.max(currentRow + layoutData.verticalSpan, this.rowCount);
                if ((currentColumn += columnSpan) == this.numColumns) {
                    currentColumn = 0;
                    ++currentRow;
                }
            }
            ++n2;
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        if (this.cachedSize != null && !flushCache) {
            return new Point(this.cachedSize.x, this.cachedSize.y);
        }
        this.createGrid(composite);
        if (this.rowCount == 0) {
            return new Point(0, 0);
        }
        int widthHint = wHint != -1 ? wHint / this.numColumns : -1;
        int[] rowSizeX = new int[this.rowCount];
        int[] rowSizeY = new int[this.rowCount];
        for (Map.Entry<Control, Point> e : this.coordinates.entrySet()) {
            DashboardLayoutData layoutData = DashboardLayout.getLayoutData(e.getKey());
            Point s = e.getKey().computeSize(widthHint != -1 ? widthHint * layoutData.horizontalSpan : -1, -1, flushCache);
            int n = e.getValue().y;
            rowSizeX[n] = rowSizeX[n] + s.x;
            if (rowSizeY[e.getValue().y] >= s.y / layoutData.verticalSpan) continue;
            rowSizeY[e.getValue().y] = s.y / layoutData.verticalSpan;
        }
        Point size = new Point(0, 0);
        int i = 0;
        while (i < this.rowCount) {
            if (size.x < rowSizeX[i]) {
                size.x = rowSizeX[i];
            }
            if (size.y < rowSizeX[i]) {
                size.y = rowSizeX[i];
            }
            ++i;
        }
        this.cachedSize = new Point(size.x, size.y);
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        this.createGrid(composite);
        if (this.rowCount == 0) {
            return;
        }
        Point size = composite.getSize();
        int height = size.y - this.marginHeight * 2;
        int columnWidth = (size.x - this.marginWidth * 2 - this.horizontalSpacing * (this.numColumns - 1)) / this.numColumns;
        float[] rowSize = new float[this.rowCount];
        Arrays.fill(rowSize, 0.0f);
        boolean[] rowFill = new boolean[this.rowCount];
        Arrays.fill(rowFill, false);
        for (Map.Entry<Control, Point> e : this.coordinates.entrySet()) {
            DashboardLayoutData layoutData = DashboardLayout.getLayoutData(e.getKey());
            if (layoutData.fill) {
                int i = 0;
                while (i < layoutData.verticalSpan) {
                    rowFill[e.getValue().y + i] = true;
                    ++i;
                }
                continue;
            }
            int ch = layoutData.heightHint > 0 ? layoutData.heightHint : e.getKey().computeSize((int)columnWidth, (int)-1, (boolean)flushCache).y;
            int rs = (ch - (layoutData.verticalSpan - 1) * this.verticalSpacing) / layoutData.verticalSpan;
            int i = 0;
            while (i < layoutData.verticalSpan) {
                if (rowSize[e.getValue().y + i] < (float)rs) {
                    rowSize[e.getValue().y + i] = rs;
                }
                ++i;
            }
        }
        float usedSpace = 0.0f;
        int fillRows = 0;
        int i = 0;
        while (i < this.rowCount) {
            if (rowFill[i]) {
                ++fillRows;
            }
            usedSpace += rowSize[i];
            ++i;
        }
        if (usedSpace > (float)(height - this.verticalSpacing * (this.rowCount - 1))) {
            float extraSpace = usedSpace - (float)height;
            float maxRowSize = (float)(height - this.verticalSpacing * (this.rowCount - 1)) / (float)this.rowCount;
            int i2 = 0;
            while (i2 < this.rowCount) {
                if (rowSize[i2] > maxRowSize) {
                    float delta = Math.min(rowSize[i2] - maxRowSize, extraSpace);
                    int n = i2;
                    rowSize[n] = rowSize[n] - delta;
                    extraSpace -= delta;
                    usedSpace -= delta;
                }
                ++i2;
            }
        }
        if (fillRows > 0) {
            float extraHeight = ((float)height - usedSpace - (float)(this.verticalSpacing * (this.rowCount - 1))) / (float)fillRows;
            int i3 = 0;
            while (i3 < this.rowCount) {
                if (rowFill[i3]) {
                    int n = i3;
                    rowSize[n] = rowSize[n] + extraHeight;
                }
                ++i3;
            }
        }
        this.rowStart = new int[this.rowCount];
        this.rowStart[0] = this.marginHeight;
        i = 1;
        while (i < this.rowCount) {
            this.rowStart[i] = Math.round((float)this.rowStart[i - 1] + rowSize[i - 1]) + this.verticalSpacing;
            ++i;
        }
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p;
            Control c = controlArray[n2];
            if (c.isVisible() && (p = this.coordinates.get(c)) != null) {
                DashboardLayoutData layoutData = DashboardLayout.getLayoutData(c);
                int cw = layoutData.horizontalSpan * columnWidth + (layoutData.horizontalSpan - 1) * this.horizontalSpacing;
                float ch = rowSize[p.y];
                int j = 1;
                while (j < layoutData.verticalSpan) {
                    ch += rowSize[p.y + j] + (float)this.verticalSpacing;
                    ++j;
                }
                c.setSize(cw, Math.round(ch));
                c.setLocation(p.x * (columnWidth + this.horizontalSpacing) + this.marginWidth, this.rowStart[p.y]);
            }
            ++n2;
        }
    }

    private static DashboardLayoutData getLayoutData(Control c) {
        Object data = c.getLayoutData();
        return data != null && data instanceof DashboardLayoutData ? (DashboardLayoutData)data : DashboardLayoutData.DEFAULT;
    }
}

