/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets.helpers;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;

public class AlarmAcknowledgeTimeFunctions {
    public static String[] getValues() {
        int menuSize;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            menuSize = settings.getInt("AlarmList.ackMenuSize");
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        String[] result = new String[menuSize];
        int i = 0;
        while (i < menuSize) {
            int time = settings.getInt("AlarmList.ackMenuEntry" + Integer.toString(i));
            if (time == 0) {
                Messages.get();
                result[i] = Messages.AlarmAcknowledgeTimeFunctions_ZeroMinutesEntry;
            } else {
                result[i] = AlarmAcknowledgeTimeFunctions.timeToString(time);
            }
            ++i;
        }
        return result;
    }

    private static void formatNumber(int n, String singular, String plural, StringBuilder sb) {
        if (n == 0) {
            return;
        }
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(n);
        sb.append(' ');
        if (n == 1) {
            sb.append(singular);
        } else {
            sb.append(plural);
        }
    }

    public static String timeToString(int time) {
        int days = time / 86400;
        int hours = (time - days * 86400) / 3600;
        int minutes = (time - hours * 3600 - days * 86400) / 60;
        StringBuilder sb = new StringBuilder();
        Messages.get();
        Messages.get();
        AlarmAcknowledgeTimeFunctions.formatNumber(days, Messages.AlarmAcknowledgeTimeFunctions_day, Messages.AlarmAcknowledgeTimeFunctions_days, sb);
        Messages.get();
        Messages.get();
        AlarmAcknowledgeTimeFunctions.formatNumber(hours, Messages.AlarmAcknowledgeTimeFunctions_hour, Messages.AlarmAcknowledgeTimeFunctions_hours, sb);
        Messages.get();
        Messages.get();
        AlarmAcknowledgeTimeFunctions.formatNumber(minutes, Messages.AlarmAcknowledgeTimeFunctions_minute, Messages.AlarmAcknowledgeTimeFunctions_minutes, sb);
        return sb.toString();
    }
}

