/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class FontTools {
    private static Set<String> availableFonts = null;
    private static Map<String, Font> fontCache = new HashMap<String, Font>();

    public static String findFirstAvailableFont(String[] names) {
        int n;
        if (availableFonts == null) {
            FontData[] fonts;
            availableFonts = new HashSet<String>();
            FontData[] fontDataArray = fonts = Display.getCurrent().getFontList(null, true);
            int n2 = fonts.length;
            n = 0;
            while (n < n2) {
                FontData fd = fontDataArray[n];
                availableFonts.add(fd.getName().toUpperCase());
                ++n;
            }
        }
        String[] stringArray = names;
        n = names.length;
        int n3 = 0;
        while (n3 < n) {
            String name = stringArray[n3];
            if (availableFonts.contains(name.toUpperCase())) {
                return name;
            }
            ++n3;
        }
        return null;
    }

    public static Font getFont(String[] names, int heightAdjustment, int style) {
        String name = FontTools.findFirstAvailableFont(names);
        if (name == null) {
            return null;
        }
        String key = String.valueOf(name) + "/A=" + heightAdjustment + "/" + style;
        Font f = fontCache.get(key);
        if (f != null) {
            return f;
        }
        f = new Font((Device)Display.getCurrent(), name, JFaceResources.getDefaultFont().getFontData()[0].getHeight() + heightAdjustment, style);
        fontCache.put(key, f);
        return f;
    }

    public static Font[] getFonts(String[] names, int baseHeight, int style, int count) {
        String name = FontTools.findFirstAvailableFont(names);
        if (name == null) {
            return null;
        }
        Font[] fonts = new Font[count];
        int i = 0;
        while (i < count) {
            int height = baseHeight + i;
            String key = String.valueOf(name) + "/H=" + height + "/" + style;
            Font f = fontCache.get(key);
            if (f == null) {
                f = new Font((Device)Display.getCurrent(), name, height, style);
                fontCache.put(key, f);
            }
            fonts[i] = f;
            ++i;
        }
        return fonts;
    }

    public static Font createFont(String[] names, int heightAdjustment, int style) {
        String name = FontTools.findFirstAvailableFont(names);
        if (name == null) {
            return null;
        }
        return new Font((Device)Display.getCurrent(), name, JFaceResources.getDefaultFont().getFontData()[0].getHeight() + heightAdjustment, style);
    }

    public static Font createFont(String[] names, int style) {
        return FontTools.createFont(names, 0, style);
    }
}

