/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.widgets.AbstractObjectStatusMap;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusMap;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusMapRadial;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectStatusMapView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectview.views.ObjectStatusMapView";
    private static final String SETTINGS_DISPLAY_MODE = "org.netxms.ui.eclipse.objectview.views.ObjectStatusMapView.DisplayMode";
    private static final String SETTINGS_SHOW_FILTER = "org.netxms.ui.eclipse.objectview.views.ObjectStatusMapView.ShowFilter";
    private long rootObjectId;
    private AbstractObjectStatusMap map;
    private Composite clientArea;
    private int displayOption = 1;
    private boolean showFilter = true;
    private Action actionRefresh;
    private Action actionFlatView;
    private Action actionGroupView;
    private Action actionRadialView;
    private Action actionShowFilter;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        NXCSession session = ConsoleSharedData.getSession();
        this.rootObjectId = Long.parseLong(site.getSecondaryId());
        AbstractObject object = session.findObjectById(this.rootObjectId);
        Messages.get();
        this.setPartName(String.format(Messages.ObjectStatusMapView_PartName, object != null ? object.getObjectName() : "[" + this.rootObjectId + "]"));
    }

    public void createPartControl(Composite parent) {
        this.clientArea = parent;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.displayOption = settings.get(SETTINGS_DISPLAY_MODE) != null ? settings.getInt(SETTINGS_DISPLAY_MODE) : 1;
        boolean bl = this.showFilter = settings.get(SETTINGS_SHOW_FILTER) != null ? settings.getBoolean(SETTINGS_SHOW_FILTER) : true;
        if (this.displayOption == 2) {
            this.map = new ObjectStatusMapRadial((IViewPart)this, parent, 0, true);
        } else {
            this.map = new ObjectStatusMap((IViewPart)this, parent, 0, true);
            ((ObjectStatusMap)this.map).setGroupObjects(this.displayOption == 1);
        }
        this.map.setRootObject(this.rootObjectId);
        this.map.enableFilter(this.showFilter);
        this.map.setFilterCloseAction(new Action(){

            public void run() {
                ObjectStatusMapView.this.showFilter = false;
                ObjectStatusMapView.this.actionShowFilter.setChecked(false);
                ObjectStatusMapView.this.map.enableFilter(false);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.map);
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (this.actionFlatView.isChecked()) {
            settings.put(SETTINGS_DISPLAY_MODE, 0);
        } else if (this.actionGroupView.isChecked()) {
            settings.put(SETTINGS_DISPLAY_MODE, 1);
        } else if (this.actionRadialView.isChecked()) {
            settings.put(SETTINGS_DISPLAY_MODE, 2);
        }
        settings.put(SETTINGS_SHOW_FILTER, this.showFilter);
        super.dispose();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ObjectStatusMapView.this.map.refresh();
            }
        };
        this.actionFlatView = new Action("&Flat view", 8){

            public void run() {
                ((ObjectStatusMap)ObjectStatusMapView.this.map).setGroupObjects(false);
                ObjectStatusMapView.this.map.refresh();
            }
        };
        this.actionFlatView.setChecked(this.displayOption == 0);
        this.actionFlatView.setImageDescriptor(Activator.getImageDescriptor("icons/not_grouped_nodes.png"));
        this.actionGroupView = new Action("&Group view", 8){

            public void run() {
                ((ObjectStatusMap)ObjectStatusMapView.this.map).setGroupObjects(true);
                ObjectStatusMapView.this.map.refresh();
            }
        };
        this.actionGroupView.setChecked(this.displayOption == 1);
        this.actionGroupView.setImageDescriptor(Activator.getImageDescriptor("icons/grouped_nodes.png"));
        this.actionRadialView = new Action("&Radial view", 8){

            public void run() {
                ObjectStatusMapView.this.redraw(ObjectStatusMapView.this.actionRadialView.isChecked());
            }
        };
        this.actionRadialView.setChecked(this.displayOption == 2);
        this.actionRadialView.setImageDescriptor(Activator.getImageDescriptor("icons/radial.png"));
        Messages.get();
        this.actionShowFilter = new Action(Messages.ObjectStatusMapView_ActionShowFilter, 2){

            public void run() {
                ObjectStatusMapView.this.showFilter = ObjectStatusMapView.this.actionShowFilter.isChecked();
                ObjectStatusMapView.this.map.enableFilter(ObjectStatusMapView.this.showFilter);
            }
        };
        this.actionShowFilter.setChecked(this.showFilter);
    }

    private void redraw(boolean radial) {
        this.map.dispose();
        this.map = radial ? new ObjectStatusMapRadial((IViewPart)this, this.clientArea, 0, true) : new ObjectStatusMap((IViewPart)this, this.clientArea, 0, true);
        this.map.setRootObject(this.rootObjectId);
        this.map.enableFilter(this.showFilter);
        this.map.setFilterCloseAction(new Action(){

            public void run() {
                ObjectStatusMapView.this.showFilter = false;
                ObjectStatusMapView.this.actionShowFilter.setChecked(false);
                ObjectStatusMapView.this.map.enableFilter(false);
            }
        });
        this.map.layout();
        this.map.getParent().layout();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionFlatView);
        manager.add((IAction)this.actionGroupView);
        manager.add((IAction)this.actionRadialView);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionFlatView);
        manager.add((IAction)this.actionGroupView);
        manager.add((IAction)this.actionRadialView);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.map.setFocus();
    }
}

