/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._collections;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._collections.PyDeque$deque___copy___exposer;
import org.python.modules._collections.PyDeque$deque___delitem___exposer;
import org.python.modules._collections.PyDeque$deque___ge___exposer;
import org.python.modules._collections.PyDeque$deque___getitem___exposer;
import org.python.modules._collections.PyDeque$deque___gt___exposer;
import org.python.modules._collections.PyDeque$deque___init___exposer;
import org.python.modules._collections.PyDeque$deque___iter___exposer;
import org.python.modules._collections.PyDeque$deque___len___exposer;
import org.python.modules._collections.PyDeque$deque___lt___exposer;
import org.python.modules._collections.PyDeque$deque___ne___exposer;
import org.python.modules._collections.PyDeque$deque___reduce___exposer;
import org.python.modules._collections.PyDeque$deque___setitem___exposer;
import org.python.modules._collections.PyDeque$deque_append_exposer;
import org.python.modules._collections.PyDeque$deque_clear_exposer;
import org.python.modules._collections.PyDeque$deque_count_exposer;
import org.python.modules._collections.PyDeque$deque_extend_exposer;
import org.python.modules._collections.PyDeque$deque_hashCode_exposer;
import org.python.modules._collections.PyDeque$deque_pop_exposer;
import org.python.modules._collections.PyDeque$deque_popleft_exposer;
import org.python.modules._collections.PyDeque$deque_remove_exposer;
import org.python.modules._collections.PyDeque$deque_reverse_exposer;
import org.python.modules._collections.PyDeque$deque_rotate_exposer;
import org.python.modules._collections.PyDeque$deque_toString_exposer;
import org.python.modules._collections.PyDeque$exposed___new__;
import org.python.modules._collections.PyDeque$maxlen_descriptor;

@ExposedType(name="collections.deque")
public class PyDeque
extends PyObject
implements Traverseproc {
    public static final PyType TYPE;
    private long state = 0L;
    private int size = 0;
    private int maxlen = -1;
    private Node header = new Node(null, null, null);

    public PyDeque() {
        this(TYPE);
    }

    public PyDeque(PyType subType) {
        super(subType);
        this.header.left = (this.header.right = this.header);
    }

    @ExposedNew
    public final synchronized void deque___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("deque", args, kwds, new String[]{"iterable", "maxlen"}, 0);
        PyObject maxlenobj = ap.getPyObject(1, null);
        if (maxlenobj != null) {
            if (maxlenobj == Py.None) {
                this.maxlen = -1;
            } else {
                this.maxlen = ap.getInt(1);
                if (this.maxlen < 0) {
                    throw Py.ValueError("maxlen must be non-negative");
                }
            }
        } else {
            this.maxlen = -1;
        }
        PyObject iterable = ap.getPyObject(0, null);
        if (iterable != null) {
            if (this.size != 0) {
                this.deque_clear();
            }
            this.deque_extend(iterable);
        }
    }

    public PyObject getMaxlen() {
        if (this.maxlen < 0) {
            return Py.None;
        }
        return Py.newInteger(this.maxlen);
    }

    public void setMaxlen(PyObject o) {
        throw Py.AttributeError("attribute 'maxlen' of 'collections.deque' objects is not writable");
    }

    public final synchronized void deque_append(PyObject obj) {
        if (this.maxlen >= 0) {
            assert (this.size <= this.maxlen);
            if (this.maxlen == 0) {
                return;
            }
            if (this.size == this.maxlen) {
                this.deque_popleft();
            }
        }
        this.addBefore(obj, this.header);
    }

    public final synchronized void deque_appendleft(PyObject obj) {
        if (this.maxlen >= 0) {
            assert (this.size <= this.maxlen);
            if (this.maxlen == 0) {
                return;
            }
            if (this.size == this.maxlen) {
                this.deque_pop();
            }
        }
        this.addBefore(obj, this.header.right);
    }

    private Node addBefore(PyObject obj, Node node) {
        Node newNode = new Node(obj, node, node.left);
        newNode.left.right = newNode;
        newNode.right.left = newNode;
        ++this.size;
        ++this.state;
        return newNode;
    }

    public final synchronized void deque_clear() {
        Node node = this.header.right;
        while (node != this.header) {
            Node right = node.right;
            node.left = null;
            node.right = null;
            node.data = null;
            node = right;
            ++this.state;
        }
        this.header.right = (this.header.left = this.header);
        this.size = 0;
    }

    public final synchronized void deque_extend(PyObject iterable) {
        if (this == iterable) {
            this.deque_extend(new PyList(iterable));
        } else {
            for (PyObject item : iterable.asIterable()) {
                this.deque_append(item);
            }
        }
    }

    public final synchronized void deque_extendleft(PyObject iterable) {
        if (this == iterable) {
            this.deque_extendleft(new PyList(iterable));
        } else {
            for (PyObject item : iterable.asIterable()) {
                this.deque_appendleft(item);
            }
        }
    }

    public final synchronized PyObject deque_pop() {
        return this.removeNode(this.header.left);
    }

    public final synchronized PyObject deque_popleft() {
        return this.removeNode(this.header.right);
    }

    private PyObject removeNode(Node node) {
        if (node == this.header) {
            throw Py.IndexError("pop from an empty deque");
        }
        PyObject obj = node.data;
        node.left.right = node.right;
        node.right.left = node.left;
        node.right = null;
        node.left = null;
        node.data = null;
        --this.size;
        ++this.state;
        return obj;
    }

    public final synchronized PyObject deque_remove(PyObject value) {
        int n = this.size;
        Node tmp = this.header.right;
        boolean match = false;
        long startState = this.state;
        for (int i = 0; i < n; ++i) {
            if (tmp.data.equals(value)) {
                match = true;
            }
            if (startState != this.state) {
                throw Py.IndexError("deque mutated during remove().");
            }
            if (match) {
                return this.removeNode(tmp);
            }
            tmp = tmp.right;
        }
        throw Py.ValueError("deque.remove(x): x not in deque");
    }

    public final synchronized PyObject deque_count(PyObject x) {
        int n = this.size;
        int count2 = 0;
        Node tmp = this.header.right;
        long startState = this.state;
        for (int i = 0; i < n; ++i) {
            if (tmp.data.equals(x)) {
                ++count2;
            }
            if (startState != this.state) {
                throw Py.RuntimeError("deque mutated during count().");
            }
            tmp = tmp.right;
        }
        return Py.newInteger(count2);
    }

    public final synchronized void deque_rotate(int steps) {
        int i;
        if (this.size == 0) {
            return;
        }
        int halfsize = this.size + 1 >> 1;
        if (steps > halfsize || steps < -halfsize) {
            if ((steps %= this.size) > halfsize) {
                steps -= this.size;
            } else if (steps < -halfsize) {
                steps += this.size;
            }
        }
        for (i = 0; i < steps; ++i) {
            this.deque_appendleft(this.deque_pop());
        }
        for (i = 0; i > steps; --i) {
            this.deque_append(this.deque_popleft());
        }
    }

    public final synchronized PyObject deque_reverse() {
        Node headerRight = this.header.right;
        Node headerLeft = this.header.left;
        Node node = this.header.right;
        while (node != this.header) {
            Node right = node.right;
            Node left = node.left;
            node.right = left;
            node.left = right;
            node = right;
        }
        this.header.right = headerLeft;
        this.header.left = headerRight;
        ++this.state;
        return Py.None;
    }

    @Override
    public String toString() {
        return this.deque_toString();
    }

    final synchronized String deque_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "[...]";
        }
        long startState = this.state;
        StringBuilder buf = new StringBuilder("deque").append("([");
        Node tmp = this.header.right;
        while (tmp != this.header) {
            buf.append(tmp.data.__repr__().toString());
            if (startState != this.state) {
                throw Py.RuntimeError("deque mutated during iteration.");
            }
            if (tmp.right != this.header) {
                buf.append(", ");
            }
            tmp = tmp.right;
        }
        buf.append("]");
        if (this.maxlen >= 0) {
            buf.append(", maxlen=");
            buf.append(this.maxlen);
        }
        buf.append(")");
        ts.exitRepr(this);
        return buf.toString();
    }

    @Override
    public int __len__() {
        return this.deque___len__();
    }

    final synchronized int deque___len__() {
        return this.size;
    }

    @Override
    public boolean __nonzero__() {
        return this.deque___nonzero__();
    }

    final synchronized boolean deque___nonzero__() {
        return this.size != 0;
    }

    @Override
    public PyObject __finditem__(PyObject key) {
        try {
            return this.deque___getitem__(key);
        }
        catch (PyException pe) {
            if (pe.match(Py.KeyError)) {
                return null;
            }
            throw pe;
        }
    }

    final synchronized PyObject deque___getitem__(PyObject index) {
        return this.getNode(index).data;
    }

    @Override
    public void __setitem__(PyObject index, PyObject value) {
        this.deque___setitem__(index, value);
    }

    final synchronized void deque___setitem__(PyObject index, PyObject value) {
        Node node = this.getNode(index).right;
        this.removeNode(node.left);
        this.addBefore(value, node);
    }

    @Override
    public void __delitem__(PyObject key) {
        this.deque___delitem__(key);
    }

    final synchronized void deque___delitem__(PyObject key) {
        this.removeNode(this.getNode(key));
    }

    private Node getNode(PyObject index) {
        int pos = 0;
        if (!index.isIndex()) {
            throw Py.TypeError(String.format("sequence index must be integer, not '%.200s'", index.getType().fastGetName()));
        }
        pos = index.asIndex(Py.IndexError);
        if (pos < 0) {
            pos += this.size;
        }
        if (pos < 0 || pos >= this.size) {
            throw Py.IndexError("index out of range: " + index);
        }
        Node tmp = this.header;
        if (pos < this.size >> 1) {
            for (int i = 0; i <= pos; ++i) {
                tmp = tmp.right;
            }
        } else {
            for (int i = this.size - 1; i >= pos; --i) {
                tmp = tmp.left;
            }
        }
        return tmp;
    }

    @Override
    public PyObject __iter__() {
        return this.deque___iter__();
    }

    final PyObject deque___iter__() {
        return new PyDequeIter();
    }

    @Override
    public synchronized PyObject __eq__(PyObject o) {
        return this.deque___eq__(o);
    }

    final synchronized PyObject deque___eq__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.False;
        }
        int i = PyDeque.cmp(this, tl, o, ol);
        return i < 0 ? Py.True : Py.False;
    }

    @Override
    public synchronized PyObject __ne__(PyObject o) {
        return this.deque___ne__(o);
    }

    final synchronized PyObject deque___ne__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.True;
        }
        int i = PyDeque.cmp(this, tl, o, ol);
        return i < 0 ? Py.False : Py.True;
    }

    @Override
    public synchronized PyObject __lt__(PyObject o) {
        return this.deque___lt__(o);
    }

    final synchronized PyObject deque___lt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PyDeque.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._lt(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __le__(PyObject o) {
        return this.deque___le__(o);
    }

    final synchronized PyObject deque___le__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PyDeque.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 || i == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._le(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __gt__(PyObject o) {
        return this.deque___gt__(o);
    }

    final synchronized PyObject deque___gt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PyDeque.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._gt(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __ge__(PyObject o) {
        return this.deque___ge__(o);
    }

    final synchronized PyObject deque___ge__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PyDeque.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 || i == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._ge(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __iadd__(PyObject o) {
        return this.deque___iadd__(o);
    }

    final synchronized PyObject deque___iadd__(PyObject o) {
        this.deque_extend(o);
        return this;
    }

    protected static int cmp(PyObject o1, int ol1, PyObject o2, int ol2) {
        if (ol1 < 0) {
            ol1 = o1.__len__();
        }
        if (ol2 < 0) {
            ol2 = o2.__len__();
        }
        for (int i = 0; i < ol1 && i < ol2; ++i) {
            if (o1.__getitem__(i).equals(o2.__getitem__(i))) continue;
            return i;
        }
        if (ol1 == ol2) {
            return -2;
        }
        return ol1 < ol2 ? -1 : -3;
    }

    @Override
    public int hashCode() {
        return this.deque_hashCode();
    }

    final int deque_hashCode() {
        throw Py.TypeError("deque objects are unhashable");
    }

    @Override
    public PyObject __reduce__() {
        return this.deque___reduce__();
    }

    final PyObject deque___reduce__() {
        PyObject dict = this.getDict();
        if (dict == null) {
            dict = Py.None;
        }
        return new PyTuple(this.getType(), Py.EmptyTuple, dict, this.__iter__());
    }

    final PyObject deque___copy__() {
        PyDeque pd = (PyDeque)this.getType().__call__();
        pd.deque_extend(this);
        return pd;
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isSequenceType() {
        return true;
    }

    @Override
    public synchronized int traverse(Visitproc visit, Object arg) {
        if (this.header == null) {
            return 0;
        }
        int retVal = 0;
        if (this.header.data != null && (retVal = visit.visit(this.header.data, arg)) != 0) {
            return retVal;
        }
        Node tmp = this.header.right;
        while (tmp != this.header) {
            if (tmp.data != null && (retVal = visit.visit(tmp.data, arg)) != 0) {
                return retVal;
            }
            tmp = tmp.right;
        }
        return retVal;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    static {
        PyType.addBuilder(PyDeque.class, new PyDeque$PyExposer());
        TYPE = PyType.fromClass(PyDeque.class);
    }

    private class PyDequeIter
    extends PyIterator {
        private Node lastReturned;
        private long startState;

        public PyDequeIter() {
            this.lastReturned = PyDeque.this.header;
            this.startState = PyDeque.this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PyObject __iternext__() {
            PyDeque pyDeque = PyDeque.this;
            synchronized (pyDeque) {
                if (this.startState != PyDeque.this.state) {
                    throw Py.RuntimeError("deque changed size during iteration");
                }
                if (this.lastReturned.right != PyDeque.this.header) {
                    this.lastReturned = this.lastReturned.right;
                    return this.lastReturned.data;
                }
                return null;
            }
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            int retVal = super.traverse(visit, arg);
            if (retVal != 0) {
                return retVal;
            }
            return PyDeque.this.traverse(visit, arg);
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) throws UnsupportedOperationException {
            if (ob == null) {
                return false;
            }
            if (super.refersDirectlyTo(ob)) {
                return true;
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class Node {
        private Node left;
        private Node right;
        private PyObject data;

        Node(PyObject data, Node right, Node left) {
            this.data = data;
            this.right = right;
            this.left = left;
        }
    }

    public class PyDeque$deque_appendleft_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_appendleft_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyDeque$deque_appendleft_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyDeque$deque_appendleft_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyDeque)this.self).deque_appendleft(pyObject);
            return Py.None;
        }
    }

    public class PyDeque$deque_extendleft_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_extendleft_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyDeque$deque_extendleft_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyDeque$deque_extendleft_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyDeque)this.self).deque_extendleft(pyObject);
            return Py.None;
        }
    }

    public class PyDeque$deque___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___nonzero___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyDeque$deque___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyDeque$deque___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyDeque)this.self).deque___nonzero__());
        }
    }

    public class PyDeque$deque___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___eq___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyDeque$deque___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyDeque$deque___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyDeque)this.self).deque___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyDeque$deque___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___le___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyDeque$deque___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyDeque$deque___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyDeque)this.self).deque___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyDeque$deque___iadd___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___iadd___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyDeque$deque___iadd___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyDeque$deque___iadd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyDeque)this.self).deque___iadd__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyDeque$PyExposer
    extends BaseTypeBuilder {
        public PyDeque$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyDeque$deque___init___exposer("__init__"), new PyDeque$deque_append_exposer("append"), new PyDeque$deque_appendleft_exposer("appendleft"), new PyDeque$deque_clear_exposer("clear"), new PyDeque$deque_extend_exposer("extend"), new PyDeque$deque_extendleft_exposer("extendleft"), new PyDeque$deque_pop_exposer("pop"), new PyDeque$deque_popleft_exposer("popleft"), new PyDeque$deque_remove_exposer("remove"), new PyDeque$deque_count_exposer("count"), new PyDeque$deque_rotate_exposer("rotate"), new PyDeque$deque_reverse_exposer("reverse"), new PyDeque$deque_toString_exposer("__repr__"), new PyDeque$deque___len___exposer("__len__"), new PyDeque$deque___nonzero___exposer("__nonzero__"), new PyDeque$deque___getitem___exposer("__getitem__"), new PyDeque$deque___setitem___exposer("__setitem__"), new PyDeque$deque___delitem___exposer("__delitem__"), new PyDeque$deque___iter___exposer("__iter__"), new PyDeque$deque___eq___exposer("__eq__"), new PyDeque$deque___ne___exposer("__ne__"), new PyDeque$deque___lt___exposer("__lt__"), new PyDeque$deque___le___exposer("__le__"), new PyDeque$deque___gt___exposer("__gt__"), new PyDeque$deque___ge___exposer("__ge__"), new PyDeque$deque___iadd___exposer("__iadd__"), new PyDeque$deque_hashCode_exposer("__hash__"), new PyDeque$deque___reduce___exposer("__reduce__"), new PyDeque$deque___copy___exposer("__copy__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyDeque$maxlen_descriptor()};
            super("collections.deque", PyDeque.class, Object.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new PyDeque$exposed___new__());
        }
    }
}

