/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.bz2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.python.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.Untraversable;
import org.python.core.util.StringUtil;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.bz2.PyBZ2Compressor$BZ2Compressor_compress_exposer;
import org.python.modules.bz2.PyBZ2Compressor$exposed___new__;

@Untraversable
@ExposedType(name="bz2.BZ2Compressor")
public class PyBZ2Compressor
extends PyObject {
    private CaptureStream captureStream = null;
    private BZip2CompressorOutputStream compressStream = null;
    public static final PyType TYPE;

    public PyBZ2Compressor() {
        super(TYPE);
    }

    public PyBZ2Compressor(PyType subType) {
        super(subType);
    }

    @ExposedNew
    final void BZ2Compressor___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("bz2compressor", args, kwds, new String[]{"compresslevel"}, 0);
        int compresslevel = ap.getInt(0, 9);
        try {
            this.captureStream = new CaptureStream();
            this.compressStream = new BZip2CompressorOutputStream(this.captureStream, compresslevel);
        }
        catch (IOException e) {
            throw Py.IOError(e.getMessage());
        }
    }

    public PyString BZ2Compressor_compress(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("compress", args, kwds, new String[]{"data"}, 1);
        PyString data = (PyString)ap.getPyObject(0);
        PyString returnData = null;
        try {
            this.compressStream.write(data.toBytes());
            returnData = this.readData();
        }
        catch (IOException e) {
            throw Py.IOError(e.getMessage());
        }
        return returnData;
    }

    private PyString readData() {
        if (!this.captureStream.hasData()) {
            return Py.EmptyString;
        }
        byte[] buf = this.captureStream.readData();
        this.captureStream.resetByteArray();
        return new PyString(StringUtil.fromBytes(buf));
    }

    public PyString BZ2Compressor_flush(PyObject[] args, String[] kwds) {
        PyString finalData = Py.EmptyString;
        try {
            this.compressStream.finish();
            this.compressStream.close();
            finalData = this.readData();
            this.captureStream.close();
        }
        catch (IOException e) {
            throw Py.IOError(e.getMessage());
        }
        return finalData;
    }

    static {
        PyType.addBuilder(PyBZ2Compressor.class, new PyBZ2Compressor$PyExposer());
        TYPE = PyType.fromClass(PyBZ2Compressor.class);
    }

    private class CaptureStream
    extends OutputStream {
        private final ByteArrayOutputStream capturedData = new ByteArrayOutputStream();

        private CaptureStream() {
        }

        @Override
        public void write(int byteData) throws IOException {
            this.capturedData.write(byteData);
        }

        public byte[] readData() {
            return this.capturedData.toByteArray();
        }

        public void resetByteArray() {
            this.capturedData.reset();
        }

        public boolean hasData() {
            return this.capturedData.size() > 0;
        }
    }

    public class PyBZ2Compressor$BZ2Compressor_flush_exposer
    extends PyBuiltinMethod {
        public PyBZ2Compressor$BZ2Compressor_flush_exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PyBZ2Compressor$BZ2Compressor_flush_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2Compressor$BZ2Compressor_flush_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyBZ2Compressor)this.self).BZ2Compressor_flush(pyObjectArray, stringArray);
        }
    }

    public class PyBZ2Compressor$PyExposer
    extends BaseTypeBuilder {
        public PyBZ2Compressor$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyBZ2Compressor$BZ2Compressor_compress_exposer("compress"), new PyBZ2Compressor$BZ2Compressor_flush_exposer("flush")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("bz2.BZ2Compressor", PyBZ2Compressor.class, Object.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new PyBZ2Compressor$exposed___new__());
        }
    }
}

