/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.bz2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.python.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.python.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.Untraversable;
import org.python.core.finalization.FinalizableBuiltin;
import org.python.core.finalization.FinalizablePyObject;
import org.python.core.finalization.FinalizeTrigger;
import org.python.core.io.BinaryIOWrapper;
import org.python.core.io.BufferedReader;
import org.python.core.io.BufferedWriter;
import org.python.core.io.StreamIO;
import org.python.core.io.TextIOBase;
import org.python.core.io.UniversalIOWrapper;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.bz2.PyBZ2File$BZ2File_close_exposer;
import org.python.modules.bz2.PyBZ2File$BZ2File_read_exposer;
import org.python.modules.bz2.PyBZ2File$BZ2File_readlines_exposer;
import org.python.modules.bz2.PyBZ2File$BZ2File_tell_exposer;
import org.python.modules.bz2.PyBZ2File$BZ2File_write_exposer;
import org.python.modules.bz2.PyBZ2File$BZ2File_xreadlines_exposer;
import org.python.modules.bz2.PyBZ2File$__del___exposer;
import org.python.modules.bz2.PyBZ2File$exposed___new__;
import org.python.modules.bz2.PyBZ2File$newlines_descriptor;

@Untraversable
@ExposedType(name="bz2.BZ2File")
public class PyBZ2File
extends PyObject
implements FinalizablePyObject,
FinalizableBuiltin {
    public static final PyType TYPE;
    private int buffering;
    private TextIOBase buffer;
    private String fileName = null;
    private boolean inIterMode = false;
    private boolean inUniversalNewlineMode = false;
    private boolean needReadBufferInit = false;
    private boolean inReadMode = false;
    private boolean inWriteMode = false;

    public PyObject PyBZ2File_newlines() {
        if (this.buffer != null) {
            return this.buffer.getNewlines();
        }
        return Py.None;
    }

    public PyBZ2File() {
        super(TYPE);
        FinalizeTrigger.ensureFinalizer(this);
    }

    public PyBZ2File(PyType subType) {
        super(subType);
        FinalizeTrigger.ensureFinalizer(this);
    }

    @Override
    public void __del_builtin__() {
        this.BZ2File_close();
    }

    @ExposedNew
    final void BZ2File___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("bz2file", args, kwds, new String[]{"filename", "mode", "buffering", "compresslevel"}, 1);
        PyObject filename = ap.getPyObject(0);
        if (!(filename instanceof PyString)) {
            throw Py.TypeError("coercing to Unicode: need string, '" + filename.getType().fastGetName() + "' type found");
        }
        String mode = ap.getString(1, "r");
        int buffering = ap.getInt(2, 0);
        int compresslevel = ap.getInt(3, 9);
        this.BZ2File___init__((PyString)filename, mode, buffering, compresslevel);
    }

    private void BZ2File___init__(PyString inFileName, String mode, int buffering, int compresslevel) {
        try {
            this.fileName = inFileName.asString();
            this.buffering = buffering;
            if (mode.contains("U")) {
                this.inUniversalNewlineMode = true;
            }
            if (mode.contains("w")) {
                this.inWriteMode = true;
                File f = new File(this.fileName);
                if (!f.exists()) {
                    f.createNewFile();
                }
                BZip2CompressorOutputStream writeStream = new BZip2CompressorOutputStream(new FileOutputStream(this.fileName), compresslevel);
                this.buffer = new BinaryIOWrapper(new BufferedWriter(new SkippableStreamIO(writeStream, true), buffering));
            } else {
                File f = new File(this.fileName);
                if (!f.exists()) {
                    throw new FileNotFoundException();
                }
                this.inReadMode = true;
                this.needReadBufferInit = true;
            }
        }
        catch (IOException e) {
            throw Py.IOError("File " + this.fileName + " not found,");
        }
    }

    private void makeReadBuffer() {
        try {
            FileInputStream fin = new FileInputStream(this.fileName);
            BufferedInputStream bin = new BufferedInputStream(fin);
            BZip2CompressorInputStream bZin = new BZip2CompressorInputStream(bin, true);
            BufferedReader bufferedReader = new BufferedReader(new SkippableStreamIO(bZin, true), this.buffering);
            this.buffer = this.inUniversalNewlineMode ? new UniversalIOWrapper(bufferedReader) : new BinaryIOWrapper(bufferedReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw Py.IOError(fileNotFoundException);
        }
        catch (IOException ioe) {
            throw Py.EOFError(ioe.getMessage());
        }
    }

    @Override
    public void __del__() {
        this.BZ2File_close();
    }

    public void BZ2File_close() {
        this.needReadBufferInit = false;
        this.BZ2File_flush();
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    private void BZ2File_flush() {
        if (this.buffer != null) {
            this.buffer.flush();
        }
    }

    public PyObject BZ2File_read(PyObject[] args, String[] kwds) {
        String chunk2;
        this.checkInIterMode();
        this.checkReadBufferInit();
        ArgParser ap = new ArgParser("read", args, kwds, new String[]{"size"}, 0);
        int size = ap.getInt(0, -1);
        if (size == 0) {
            return Py.EmptyString;
        }
        if (size < 0) {
            return new PyString(this.buffer.readall());
        }
        StringBuilder data = new StringBuilder(size);
        while (data.length() < size && (chunk2 = this.buffer.read(size - data.length())).length() != 0) {
            data.append(chunk2);
        }
        return new PyString(data.toString());
    }

    public PyObject BZ2File_next(PyObject[] args, String[] kwds) {
        this.checkReadBufferInit();
        if (this.buffer == null || this.buffer.closed()) {
            throw Py.ValueError("Cannot call next() on closed file");
        }
        this.inIterMode = true;
        return null;
    }

    public PyString BZ2File_readline(PyObject[] args, String[] kwds) {
        this.checkInIterMode();
        this.checkReadBufferInit();
        ArgParser ap = new ArgParser("read", args, kwds, new String[]{"size"}, 0);
        int size = ap.getInt(0, -1);
        return new PyString(this.buffer.readline(size));
    }

    public PyList BZ2File_readlines(PyObject[] args, String[] kwds) {
        this.checkInIterMode();
        this.checkReadBufferInit();
        if (this.buffer == null || this.buffer.closed()) {
            throw Py.ValueError("Cannot call readlines() on a closed file");
        }
        PyList lineList = new PyList();
        PyString line = null;
        while (!(line = this.BZ2File_readline(args, kwds)).equals(Py.EmptyString)) {
            lineList.add(line);
        }
        return lineList;
    }

    private void checkInIterMode() {
        if (this.inReadMode && this.inIterMode) {
            throw Py.ValueError("Cannot mix iteration and reads");
        }
    }

    private void checkReadBufferInit() {
        if (this.inReadMode && this.needReadBufferInit) {
            this.makeReadBuffer();
            this.needReadBufferInit = false;
        }
    }

    public PyList BZ2File_xreadlines() {
        return this.BZ2File_readlines(new PyObject[0], new String[0]);
    }

    public void BZ2File_seek(PyObject[] args, String[] kwds) {
        if (!this.inReadMode) {
            Py.IOError("seek works only while reading");
        }
        ArgParser ap = new ArgParser("seek", args, kwds, new String[]{"offset", "whence"}, 1);
        this.checkReadBufferInit();
        int newOffset = ap.getInt(0);
        int whence = ap.getInt(1, 0);
        long currentPos = this.buffer.tell();
        long finalOffset = 0L;
        switch (whence) {
            case 0: {
                finalOffset = newOffset;
                break;
            }
            case 1: {
                finalOffset = currentPos + (long)newOffset;
                break;
            }
            case 2: {
                String data;
                long fileSize = currentPos;
                while (!(data = this.buffer.read(8192)).isEmpty()) {
                    fileSize += (long)data.length();
                }
                finalOffset = fileSize + (long)newOffset;
                this.buffer.close();
                this.makeReadBuffer();
            }
        }
        if (finalOffset < 0L) {
            finalOffset = 0L;
        }
        if (whence != 2 && finalOffset < currentPos) {
            this.buffer.close();
            this.makeReadBuffer();
        }
        this.buffer.seek(finalOffset, 0);
    }

    public PyLong BZ2File_tell() {
        this.checkReadBufferInit();
        if (this.buffer == null) {
            return Py.newLong(0);
        }
        return Py.newLong(this.buffer.tell());
    }

    public void BZ2File_write(PyObject[] args, String[] kwds) {
        this.checkFileWritable();
        ArgParser ap = new ArgParser("write", args, kwds, new String[]{"data"}, 0);
        PyObject data = ap.getPyObject(0);
        if (data.getType() == PyNone.TYPE) {
            throw Py.TypeError("Expecting str argument");
        }
        this.buffer.write(ap.getString(0));
    }

    public void BZ2File_writelines(PyObject[] args, String[] kwds) {
        this.checkFileWritable();
        ArgParser ap = new ArgParser("writelines", args, kwds, new String[]{"sequence_of_strings"}, 0);
        PySequence seq = (PySequence)ap.getPyObject(0);
        for (PyObject line : seq.asIterable()) {
            this.BZ2File_write(new PyObject[]{line}, new String[]{"data"});
        }
    }

    private void checkFileWritable() {
        if (this.inReadMode) {
            throw Py.IOError("File in read-only mode");
        }
        if (this.buffer == null || this.buffer.closed()) {
            throw Py.ValueError("Stream closed");
        }
    }

    @Override
    public PyObject __iter__() {
        return new BZ2FileIterator();
    }

    public PyObject BZ2File___enter__() {
        if (this.inWriteMode ? this.buffer == null : this.inReadMode && !this.needReadBufferInit && (this.buffer == null || this.buffer.closed())) {
            throw Py.ValueError("Stream closed");
        }
        return this;
    }

    public boolean BZ2File___exit__(PyObject exc_type, PyObject exc_value, PyObject traceback2) {
        this.BZ2File_close();
        return false;
    }

    static {
        PyType.addBuilder(PyBZ2File.class, new PyBZ2File$PyExposer());
        TYPE = PyType.fromClass(PyBZ2File.class);
    }

    private static class SkippableStreamIO
    extends StreamIO {
        private long position = 0L;

        public SkippableStreamIO(InputStream inputStream, boolean closefd) {
            super(inputStream, closefd);
        }

        public SkippableStreamIO(OutputStream outputStream, boolean closefd) {
            super(outputStream, closefd);
        }

        @Override
        public int readinto(ByteBuffer buf) {
            int bytesRead = 0;
            try {
                bytesRead = super.readinto(buf);
            }
            catch (PyException pyex) {
                throw Py.EOFError(pyex.value.asStringOrNull());
            }
            this.position += (long)bytesRead;
            return bytesRead;
        }

        @Override
        public long tell() {
            return this.position;
        }

        @Override
        public long seek(long offset, int whence) {
            long newPosition;
            long skipBytes = offset - this.position;
            if (whence != 0 || skipBytes < 0L) {
                throw Py.IOError("can only seek forward");
            }
            if (skipBytes == 0L) {
                return this.position;
            }
            long skipped = 0L;
            try {
                skipped = this.asInputStream().skip(skipBytes);
            }
            catch (IOException ex) {
                throw Py.IOError(ex);
            }
            this.position = newPosition = this.position + skipped;
            return newPosition;
        }
    }

    private class BZ2FileIterator
    extends PyIterator {
        private BZ2FileIterator() {
        }

        @Override
        public PyObject __iternext__() {
            PyString s = PyBZ2File.this.BZ2File_readline(new PyObject[0], new String[0]);
            if (s.equals(Py.EmptyString)) {
                return null;
            }
            return s;
        }
    }

    public class PyBZ2File$BZ2File___init___exposer
    extends PyBuiltinMethod {
        public PyBZ2File$BZ2File___init___exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PyBZ2File$BZ2File___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2File$BZ2File___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyBZ2File)this.self).BZ2File___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyBZ2File$BZ2File_next_exposer
    extends PyBuiltinMethod {
        public PyBZ2File$BZ2File_next_exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PyBZ2File$BZ2File_next_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2File$BZ2File_next_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyBZ2File)this.self).BZ2File_next(pyObjectArray, stringArray);
        }
    }

    public class PyBZ2File$BZ2File_readline_exposer
    extends PyBuiltinMethod {
        public PyBZ2File$BZ2File_readline_exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PyBZ2File$BZ2File_readline_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2File$BZ2File_readline_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyBZ2File)this.self).BZ2File_readline(pyObjectArray, stringArray);
        }
    }

    public class PyBZ2File$BZ2File_seek_exposer
    extends PyBuiltinMethod {
        public PyBZ2File$BZ2File_seek_exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PyBZ2File$BZ2File_seek_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2File$BZ2File_seek_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyBZ2File)this.self).BZ2File_seek(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyBZ2File$BZ2File_writelines_exposer
    extends PyBuiltinMethod {
        public PyBZ2File$BZ2File_writelines_exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PyBZ2File$BZ2File_writelines_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2File$BZ2File_writelines_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyBZ2File)this.self).BZ2File_writelines(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyBZ2File$__iter___exposer
    extends PyBuiltinMethodNarrow {
        public PyBZ2File$__iter___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyBZ2File$__iter___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2File$__iter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyBZ2File)this.self).__iter__();
        }
    }

    public class PyBZ2File$BZ2File___enter___exposer
    extends PyBuiltinMethodNarrow {
        public PyBZ2File$BZ2File___enter___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyBZ2File$BZ2File___enter___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2File$BZ2File___enter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyBZ2File)this.self).BZ2File___enter__();
        }
    }

    public class PyBZ2File$BZ2File___exit___exposer
    extends PyBuiltinMethodNarrow {
        public PyBZ2File$BZ2File___exit___exposer(String string2) {
            super(string2, 4, 4);
            this.doc = "";
        }

        public PyBZ2File$BZ2File___exit___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2File$BZ2File___exit___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newBoolean(((PyBZ2File)this.self).BZ2File___exit__(pyObject, pyObject2, pyObject3));
        }
    }

    public class PyBZ2File$PyExposer
    extends BaseTypeBuilder {
        public PyBZ2File$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyBZ2File$BZ2File___init___exposer("__init__"), new PyBZ2File$__del___exposer("__del__"), new PyBZ2File$BZ2File_close_exposer("close"), new PyBZ2File$BZ2File_read_exposer("read"), new PyBZ2File$BZ2File_next_exposer("next"), new PyBZ2File$BZ2File_readline_exposer("readline"), new PyBZ2File$BZ2File_readlines_exposer("readlines"), new PyBZ2File$BZ2File_xreadlines_exposer("xreadlines"), new PyBZ2File$BZ2File_seek_exposer("seek"), new PyBZ2File$BZ2File_tell_exposer("tell"), new PyBZ2File$BZ2File_write_exposer("write"), new PyBZ2File$BZ2File_writelines_exposer("writelines"), new PyBZ2File$__iter___exposer("__iter__"), new PyBZ2File$BZ2File___enter___exposer("__enter__"), new PyBZ2File$BZ2File___exit___exposer("__exit__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyBZ2File$newlines_descriptor()};
            super("bz2.BZ2File", PyBZ2File.class, Object.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new PyBZ2File$exposed___new__());
        }
    }
}

