/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Arrays;
import java.util.Comparator;
import org.netxms.base.NXCPMessage;

public class AgentTable {
    private String name;
    private String description;
    private String[] instanceColumns;
    private TableColumnDefinition[] columns;

    protected AgentTable(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId + 1L);
        this.description = msg.getFieldAsString(baseId + 2L);
        String t = msg.getFieldAsString(baseId + 3L);
        this.instanceColumns = t != null ? t.split("\\|") : new String[]{};
        Arrays.sort(this.instanceColumns, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        int count = msg.getFieldAsInt32(baseId) - 4;
        this.columns = new TableColumnDefinition[count];
        long varId = baseId + 4L;
        for (int i = 0; i < count; ++i) {
            this.columns[i] = new TableColumnDefinition(msg, varId);
            varId += 2L;
        }
    }

    public AgentTable(String name, String description, String[] instanceColumns) {
        this.name = name;
        this.description = description;
        this.instanceColumns = instanceColumns;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public final String[] getInstanceColumns() {
        return this.instanceColumns;
    }

    public String getInstanceColumnsAsList() {
        if (this.instanceColumns.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.instanceColumns[0]);
        for (int i = 1; i < this.instanceColumns.length; ++i) {
            sb.append(", ");
            sb.append(this.instanceColumns[i]);
        }
        return sb.toString();
    }

    public TableColumnDefinition[] getColumns() {
        return this.columns;
    }

    public class TableColumnDefinition {
        public String name;
        public int dataType;

        TableColumnDefinition(NXCPMessage msg, long baseId) {
            this.name = msg.getFieldAsString(baseId);
            this.dataType = msg.getFieldAsInt32(baseId + 1L);
        }
    }
}

