/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum MapObjectDisplayMode {
    ICON(0),
    SMALL_LABEL(1),
    LARGE_LABEL(2),
    STATUS(3),
    FLOOR_PLAN(4);

    private int value;
    private static Map<Integer, MapObjectDisplayMode> lookupTable;

    private MapObjectDisplayMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MapObjectDisplayMode getByValue(int value) {
        MapObjectDisplayMode element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)MapObjectDisplayMode.class.getName(), (String)("Unknown element " + value));
            return ICON;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, MapObjectDisplayMode>();
        for (MapObjectDisplayMode element : MapObjectDisplayMode.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

