/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.net.URI;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;

public abstract class MockMvcRequestBuilders {
    public static MockHttpServletRequestBuilder get(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.GET, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder get(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.GET, uri);
    }

    public static MockHttpServletRequestBuilder post(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.POST, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder post(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.POST, uri);
    }

    public static MockHttpServletRequestBuilder put(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.PUT, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder put(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.PUT, uri);
    }

    public static MockHttpServletRequestBuilder patch(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.PATCH, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder patch(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.PATCH, uri);
    }

    public static MockHttpServletRequestBuilder delete(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.DELETE, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder delete(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.DELETE, uri);
    }

    public static MockHttpServletRequestBuilder options(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.OPTIONS, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder options(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.OPTIONS, uri);
    }

    public static MockHttpServletRequestBuilder head(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.HEAD, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder head(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.HEAD, uri);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod httpMethod, String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(httpMethod, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod httpMethod, URI uri) {
        return new MockHttpServletRequestBuilder(httpMethod, uri);
    }

    public static MockMultipartHttpServletRequestBuilder fileUpload(String urlTemplate, Object ... urlVariables) {
        return new MockMultipartHttpServletRequestBuilder(urlTemplate, urlVariables);
    }

    public static MockMultipartHttpServletRequestBuilder fileUpload(URI uri) {
        return new MockMultipartHttpServletRequestBuilder(uri);
    }

    public static RequestBuilder asyncDispatch(final MvcResult mvcResult) {
        mvcResult.getAsyncResult();
        return new RequestBuilder(){

            @Override
            public MockHttpServletRequest buildRequest(ServletContext servletContext) {
                MockHttpServletRequest request = mvcResult.getRequest();
                request.setDispatcherType(DispatcherType.ASYNC);
                request.setAsyncStarted(false);
                return request;
            }
        };
    }
}

