/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.service.impl;

import com.radensolutions.reporting.service.MessageProcessingResult;
import com.radensolutions.reporting.service.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Arrays;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCPMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
class SessionWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SessionWorker.class);
    private static final int FILE_BUFFER_SIZE = 131072;
    final NXCPMessageReceiver messageReceiver = new NXCPMessageReceiver(262144, 0x400000);
    private final Socket socket;
    private final BufferedInputStream inputStream;
    private final BufferedOutputStream outputStream;
    @Autowired
    private Session session;
    private boolean active = true;

    public SessionWorker(Socket socket) throws IOException {
        this.socket = socket;
        this.inputStream = new BufferedInputStream(socket.getInputStream());
        this.outputStream = new BufferedOutputStream(socket.getOutputStream());
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                NXCPMessage message = this.messageReceiver.receiveMessage((InputStream)this.inputStream, null);
                if (message == null) continue;
                if (message.getMessageCode() != 3) {
                    log.debug("Request: " + message.toString());
                }
                MessageProcessingResult result = this.session.processMessage(message);
                if (result.response == null) continue;
                if (message.getMessageCode() != 3) {
                    log.debug("Reply: " + result.response.toString());
                }
                this.sendMessage(result.response);
                if (result.file == null) continue;
                log.debug("File data found, sending");
                FileInputStream s = null;
                try {
                    s = new FileInputStream(result.file);
                    this.sendFileStream(message.getMessageId(), s);
                }
                catch (IOException e) {
                    log.error("Unexpected I/O exception while sending rendered file");
                }
                if (s != null) {
                    s.close();
                }
                result.file.delete();
            }
            catch (IOException e) {
                log.info("Communication error", (Throwable)e);
                this.stop();
            }
            catch (NXCPException e) {
                log.info("Invalid message received", (Throwable)e);
                this.stop();
            }
        }
    }

    public void stop() {
        Thread.currentThread().interrupt();
        this.active = false;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean sendMessage(NXCPMessage message) {
        try {
            this.outputStream.write(message.createNXCPMessage(false));
            this.outputStream.flush();
            return true;
        }
        catch (IOException e) {
            log.error("Communication failure", (Throwable)e);
            this.stop();
            return false;
        }
    }

    public void sendFileStream(long requestId, InputStream inputStream) throws IOException {
        int bytesRead;
        NXCPMessage msg = new NXCPMessage(105, requestId);
        msg.setBinaryMessage(true);
        boolean success = false;
        byte[] buffer = new byte[131072];
        do {
            if ((bytesRead = inputStream.read(buffer)) < 131072) {
                msg.setEndOfFile(true);
            }
            msg.setBinaryData(bytesRead == -1 ? new byte[]{} : Arrays.copyOf(buffer, bytesRead));
            this.sendMessage(msg);
        } while (bytesRead >= 131072);
        success = true;
        if (!success) {
            NXCPMessage abortMessage = new NXCPMessage(114, requestId);
            abortMessage.setBinaryMessage(true);
            this.sendMessage(abortMessage);
        }
    }

    boolean isActive() {
        return this.active;
    }
}

