/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.export.AwtTextRenderer;
import net.sf.jasperreports.engine.export.GenericElementGraphics2DHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterContext;
import net.sf.jasperreports.engine.export.draw.EllipseDrawer;
import net.sf.jasperreports.engine.export.draw.FrameDrawer;
import net.sf.jasperreports.engine.export.draw.ImageDrawer;
import net.sf.jasperreports.engine.export.draw.LineDrawer;
import net.sf.jasperreports.engine.export.draw.Offset;
import net.sf.jasperreports.engine.export.draw.RectangleDrawer;
import net.sf.jasperreports.engine.export.draw.TextDrawer;
import net.sf.jasperreports.renderers.RenderersCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrintDrawVisitor
implements PrintElementVisitor<Offset> {
    private static final Log log = LogFactory.getLog(PrintDrawVisitor.class);
    private Graphics2D grx;
    private final JasperReportsContext jasperReportsContext;
    private final LineDrawer lineDrawer;
    private final RectangleDrawer rectangleDrawer;
    private final EllipseDrawer ellipseDrawer;
    private final ImageDrawer imageDrawer;
    private TextDrawer textDrawer;
    private FrameDrawer frameDrawer;

    public PrintDrawVisitor(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.lineDrawer = new LineDrawer(jasperReportsContext);
        this.rectangleDrawer = new RectangleDrawer(jasperReportsContext);
        this.ellipseDrawer = new EllipseDrawer(jasperReportsContext);
        this.imageDrawer = new ImageDrawer(jasperReportsContext, new RenderersCache(jasperReportsContext));
    }

    public PrintDrawVisitor(JasperReportsContext jasperReportsContext, RenderersCache renderersCache, boolean minimizePrinterJobSize, boolean ignoreMissingFont) {
        this.jasperReportsContext = jasperReportsContext;
        this.lineDrawer = new LineDrawer(jasperReportsContext);
        this.rectangleDrawer = new RectangleDrawer(jasperReportsContext);
        this.ellipseDrawer = new EllipseDrawer(jasperReportsContext);
        this.imageDrawer = new ImageDrawer(jasperReportsContext, renderersCache);
        AwtTextRenderer textRenderer = new AwtTextRenderer(jasperReportsContext, minimizePrinterJobSize, ignoreMissingFont);
        this.textDrawer = new TextDrawer(jasperReportsContext, textRenderer);
        this.frameDrawer = new FrameDrawer(jasperReportsContext, null, this);
    }

    public PrintDrawVisitor(JRGraphics2DExporterContext exporterContext, RenderersCache renderersCache, boolean minimizePrinterJobSize, boolean ignoreMissingFont) {
        this.jasperReportsContext = exporterContext.getJasperReportsContext();
        this.lineDrawer = new LineDrawer(this.jasperReportsContext);
        this.rectangleDrawer = new RectangleDrawer(this.jasperReportsContext);
        this.ellipseDrawer = new EllipseDrawer(this.jasperReportsContext);
        this.imageDrawer = new ImageDrawer(this.jasperReportsContext, renderersCache);
        AwtTextRenderer textRenderer = new AwtTextRenderer(this.jasperReportsContext, minimizePrinterJobSize, ignoreMissingFont);
        this.textDrawer = new TextDrawer(this.jasperReportsContext, textRenderer);
        this.frameDrawer = new FrameDrawer(exporterContext, null, this);
    }

    public void setTextRenderer(JRReport report) {
        AwtTextRenderer textRenderer = new AwtTextRenderer(this.jasperReportsContext, JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(report, "net.sf.jasperreports.export.graphics2d.min.job.size", true), JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(report, "net.sf.jasperreports.awt.ignore.missing.font", false));
        this.textDrawer = new TextDrawer(this.jasperReportsContext, textRenderer);
        this.frameDrawer = new FrameDrawer(this.jasperReportsContext, null, textRenderer);
    }

    public void setTextDrawer(TextDrawer textDrawer) {
        this.textDrawer = textDrawer;
    }

    public void setFrameDrawer(FrameDrawer frameDrawer) {
        this.frameDrawer = frameDrawer;
    }

    public void setClip(boolean isClip) {
        this.frameDrawer.setClip(isClip);
    }

    public void setGraphics2D(Graphics2D grx) {
        this.grx = grx;
    }

    @Override
    public void visit(JRPrintText textElement, Offset offset) {
        this.textDrawer.draw(this.grx, textElement, offset.getX(), offset.getY());
    }

    @Override
    public void visit(JRPrintImage image, Offset offset) {
        try {
            this.imageDrawer.draw(this.grx, image, offset.getX(), offset.getY());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public void visit(JRPrintRectangle rectangle, Offset offset) {
        this.rectangleDrawer.draw(this.grx, rectangle, offset.getX(), offset.getY());
    }

    @Override
    public void visit(JRPrintLine line, Offset offset) {
        this.lineDrawer.draw(this.grx, line, offset.getX(), offset.getY());
    }

    @Override
    public void visit(JRPrintEllipse ellipse, Offset offset) {
        this.ellipseDrawer.draw(this.grx, ellipse, offset.getX(), offset.getY());
    }

    @Override
    public void visit(JRPrintFrame frame, Offset offset) {
        try {
            this.frameDrawer.draw(this.grx, frame, offset.getX(), offset.getY());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public void visit(JRGenericPrintElement printElement, Offset offset) {
        GenericElementGraphics2DHandler handler = (GenericElementGraphics2DHandler)GenericElementHandlerEnviroment.getInstance(this.jasperReportsContext).getElementHandler(printElement.getGenericType(), "net.sf.jasperreports.graphics2d");
        if (handler != null) {
            handler.exportElement(this.frameDrawer.getExporterContext(), printElement, this.grx, offset);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No Graphics2D generic element handler for " + printElement.getGenericType()));
        }
    }

    public TextDrawer getTextDrawer() {
        return this.textDrawer;
    }

    public ImageDrawer getImageDrawer() {
        return this.imageDrawer;
    }

    public FrameDrawer getFrameDrawer() {
        return this.frameDrawer;
    }
}

