/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;

public class InetAddressListElement {
    public static final int SUBNET = 0;
    public static final int RANGE = 1;
    private int type;
    private InetAddress baseAddress;
    private InetAddress endAddress;
    private int maskBits;

    public InetAddressListElement(InetAddress baseAddress, InetAddress endAddress) {
        this.type = 1;
        this.baseAddress = baseAddress;
        this.endAddress = endAddress;
        this.maskBits = 0;
    }

    public InetAddressListElement(InetAddress baseAddress, int maskBits) {
        this.type = 0;
        this.baseAddress = baseAddress;
        this.endAddress = null;
        this.maskBits = maskBits;
    }

    protected InetAddressListElement(NXCPMessage msg, long baseId) {
        this.type = msg.getFieldAsInt32(baseId);
        this.baseAddress = msg.getFieldAsInetAddress(baseId + 1L);
        if (this.type == 0) {
            this.maskBits = msg.getFieldAsInt32(baseId + 2L);
            this.endAddress = null;
        } else {
            this.endAddress = msg.getFieldAsInetAddress(baseId + 2L);
            this.maskBits = 0;
        }
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt16(baseId, this.type);
        msg.setField(baseId + 1L, this.baseAddress);
        if (this.type == 0) {
            msg.setFieldInt16(baseId + 2L, this.maskBits);
        } else {
            msg.setField(baseId + 2L, this.endAddress);
        }
    }

    public int getType() {
        return this.type;
    }

    public InetAddress getBaseAddress() {
        return this.baseAddress;
    }

    public InetAddress getEndAddress() {
        return this.endAddress;
    }

    public int getMaskBits() {
        return this.maskBits;
    }

    public String toString() {
        return this.type == 0 ? String.valueOf(this.baseAddress.getHostAddress()) + "/" + this.maskBits : String.valueOf(this.baseAddress.getHostAddress()) + " - " + this.endAddress.getHostAddress();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.baseAddress == null ? 0 : this.baseAddress.hashCode());
        result = 31 * result + (this.endAddress == null ? 0 : this.endAddress.hashCode());
        result = 31 * result + this.maskBits;
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddressListElement other = (InetAddressListElement)obj;
        if (this.baseAddress == null ? other.baseAddress != null : !this.baseAddress.equals(other.baseAddress)) {
            return false;
        }
        if (this.endAddress == null ? other.endAddress != null : !this.endAddress.equals(other.endAddress)) {
            return false;
        }
        if (this.maskBits != other.maskBits) {
            return false;
        }
        return this.type == other.type;
    }
}

