/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum AuthenticationType {
    PASSWORD(0),
    CERTIFICATE(1),
    SSO_TICKET(2);

    private int value;
    private static Map<Integer, AuthenticationType> lookupTable;

    static {
        lookupTable = new HashMap<Integer, AuthenticationType>();
        AuthenticationType[] authenticationTypeArray = AuthenticationType.values();
        int n = authenticationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AuthenticationType element = authenticationTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private AuthenticationType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AuthenticationType getByValue(int value) {
        AuthenticationType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)AuthenticationType.class.getName(), (String)("Unknown element " + value));
            return PASSWORD;
        }
        return element;
    }
}

