/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.TableThreshold;

public class DataCollectionTable
extends DataCollectionObject {
    public static final int IDM_NONE = 0;
    public static final int IDM_AGENT_LIST = 1;
    public static final int IDM_AGENT_TABLE = 2;
    public static final int IDM_SNMP_WALK_VALUES = 3;
    public static final int IDM_SNMP_WALK_OIDS = 4;
    public static final int IDM_SCRIPT = 5;
    private String instanceColumn;
    private List<ColumnDefinition> columns;
    private List<TableThreshold> thresholds;

    public DataCollectionTable(DataCollectionConfiguration owner, NXCPMessage msg) {
        super(owner, msg);
        this.instanceColumn = msg.getFieldAsString(412L);
        int count = msg.getFieldAsInt32(166L);
        this.columns = new ArrayList<ColumnDefinition>(count);
        long fieldId = 0x30000000L;
        int i = 0;
        while (i < count) {
            this.columns.add(new ColumnDefinition(msg, fieldId));
            fieldId += 10L;
            ++i;
        }
        count = msg.getFieldAsInt32(54L);
        this.thresholds = new ArrayList<TableThreshold>(count);
        fieldId = 0x20000000L;
        i = 0;
        while (i < count) {
            TableThreshold t = new TableThreshold(msg, fieldId);
            this.thresholds.add(t);
            fieldId = t.getNextFieldId();
            ++i;
        }
    }

    public DataCollectionTable(DataCollectionConfiguration owner, long id) {
        super(owner, id);
        this.instanceColumn = null;
        this.columns = new ArrayList<ColumnDefinition>(0);
        this.thresholds = new ArrayList<TableThreshold>(0);
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setFieldInt16(411L, 2);
        msg.setField(412L, this.instanceColumn);
        msg.setFieldInt32(166L, this.columns.size());
        long varId = 0x30000000L;
        int i = 0;
        while (i < this.columns.size()) {
            this.columns.get(i).fillMessage(msg, varId);
            varId += 10L;
            ++i;
        }
        msg.setFieldInt32(54L, this.thresholds.size());
        varId = 0x20000000L;
        i = 0;
        while (i < this.thresholds.size()) {
            varId = this.thresholds.get(i).fillMessage(msg, varId);
            ++i;
        }
    }

    public String getInstanceColumn() {
        return this.instanceColumn;
    }

    public void setInstanceColumn(String instanceColumn) {
        this.instanceColumn = instanceColumn;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
    }

    public List<TableThreshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(List<TableThreshold> thresholds) {
        this.thresholds = thresholds;
    }
}

