/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.HashSet;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;

public class NetworkService
extends GenericObject {
    public static final int CUSTOM = 0;
    public static final int SSH = 1;
    public static final int POP3 = 2;
    public static final int SMTP = 3;
    public static final int FTP = 4;
    public static final int HTTP = 5;
    public static final int HTTPS = 6;
    public static final int TELNET = 7;
    int serviceType;
    InetAddressEx ipAddress;
    int protocol;
    int port;
    String request;
    String response;
    long pollerNode;
    int pollCount;

    public NetworkService(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.serviceType = msg.getFieldAsInt32(130L);
        this.ipAddress = msg.getFieldAsInetAddressEx(8L);
        this.protocol = msg.getFieldAsInt32(131L);
        this.port = msg.getFieldAsInt32(132L);
        this.request = msg.getFieldAsString(133L);
        this.response = msg.getFieldAsString(134L);
        this.pollerNode = msg.getFieldAsInt64(135L);
        this.pollCount = msg.getFieldAsInt32(299L);
    }

    @Override
    public String getObjectClassName() {
        return "NetworkService";
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public InetAddressEx getIpAddress() {
        return this.ipAddress;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public long getPollerNode() {
        return this.pollerNode;
    }

    public int getPollCount() {
        return this.pollCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNode getParentNode() {
        AbstractNode node = null;
        HashSet hashSet = this.parents;
        synchronized (hashSet) {
            for (Long id : this.parents) {
                AbstractObject object = this.session.findObjectById(id);
                if (!(object instanceof AbstractNode)) continue;
                node = (AbstractNode)object;
                break;
            }
        }
        return node;
    }
}

