/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.AgentTunnel;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class TunnelListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color COLOR_BOUND = new Color((Device)Display.getDefault(), new RGB(26, 88, 0));
    private static final Color COLOR_UNBOUND = new Color((Device)Display.getDefault(), new RGB(199, 83, 0));

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        AgentTunnel t = (AgentTunnel)element;
        switch (columnIndex) {
            case 9: {
                return t.getAgentVersion();
            }
            case 4: {
                return t.isBound() ? Integer.toString(t.getActiveChannelCount()) : "";
            }
            case 0: {
                return Integer.toString(t.getId());
            }
            case 3: {
                return t.getAddress().getHostAddress();
            }
            case 2: {
                return t.isBound() ? ConsoleSharedData.getSession().getObjectName(t.getNodeId()) : "";
            }
            case 7: {
                return t.getPlatformName();
            }
            case 1: {
                return t.isBound() ? "Bound" : "Unbound";
            }
            case 8: {
                return t.getSystemInformation();
            }
            case 5: {
                return t.getSystemName();
            }
            case 6: {
                return t.getHostname();
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        return ((AgentTunnel)element).isBound() ? COLOR_BOUND : COLOR_UNBOUND;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

