/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.base.GeoLocation;
import org.netxms.base.GeoLocationFormatException;
import org.netxms.base.PostalAddress;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class Location
extends PropertyPage {
    private AbstractObject object;
    private LabeledText latitude;
    private LabeledText longitude;
    private Button radioTypeUndefined;
    private Button radioTypeManual;
    private Button radioTypeAuto;
    private LabeledText country;
    private LabeledText city;
    private LabeledText streetAddress;
    private LabeledText postcode;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        GeoLocation gl = this.object.getGeolocation();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group typeGroup = new Group(dialogArea, 0);
        Messages.get();
        typeGroup.setText(Messages.Location_LocationType);
        GridData gd = new GridData();
        gd.verticalSpan = 2;
        typeGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        typeGroup.setLayout((Layout)layout);
        this.radioTypeUndefined = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.radioTypeUndefined.setText(Messages.Location_Undefined);
        this.radioTypeUndefined.setSelection(gl.getType() == 0);
        this.radioTypeManual = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.radioTypeManual.setText(Messages.Location_Manual);
        this.radioTypeManual.setSelection(gl.getType() == 1);
        this.radioTypeAuto = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.radioTypeAuto.setText(Messages.Location_Automatic);
        this.radioTypeAuto.setSelection(gl.getType() == 2);
        this.latitude = new LabeledText(dialogArea, 0);
        Messages.get();
        this.latitude.setLabel(Messages.Location_Latitude);
        if (gl.getType() != 0) {
            this.latitude.setText(gl.getLatitudeAsString());
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.latitude.setLayoutData((Object)gd);
        this.latitude.setEnabled(gl.getType() == 1);
        this.longitude = new LabeledText(dialogArea, 0);
        Messages.get();
        this.longitude.setLabel(Messages.Location_Longitude);
        if (gl.getType() != 0) {
            this.longitude.setText(gl.getLongitudeAsString());
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.longitude.setLayoutData((Object)gd);
        this.longitude.setEnabled(gl.getType() == 1);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Location.this.latitude.setEnabled(Location.this.radioTypeManual.getSelection());
                Location.this.longitude.setEnabled(Location.this.radioTypeManual.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioTypeUndefined.addSelectionListener(listener);
        this.radioTypeManual.addSelectionListener(listener);
        this.radioTypeAuto.addSelectionListener(listener);
        this.country = new LabeledText(dialogArea, 0);
        Messages.get();
        this.country.setLabel(Messages.Location_Country);
        this.country.setText(this.object.getPostalAddress().country);
        this.country.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.city = new LabeledText(dialogArea, 0);
        Messages.get();
        this.city.setLabel(Messages.Location_City);
        this.city.setText(this.object.getPostalAddress().city);
        this.city.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.streetAddress = new LabeledText(dialogArea, 0);
        Messages.get();
        this.streetAddress.setLabel(Messages.Location_StreetAddress);
        this.streetAddress.setText(this.object.getPostalAddress().streetAddress);
        this.streetAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.postcode = new LabeledText(dialogArea, 0);
        Messages.get();
        this.postcode.setLabel(Messages.Location_Postcode);
        this.postcode.setText(this.object.getPostalAddress().postcode);
        this.postcode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        GeoLocation location;
        int type = 0;
        if (this.radioTypeManual.getSelection()) {
            type = 1;
        } else if (this.radioTypeAuto.getSelection()) {
            type = 2;
        }
        if (type == 1) {
            try {
                location = GeoLocation.parseGeoLocation((String)this.latitude.getText(), (String)this.longitude.getText());
            }
            catch (GeoLocationFormatException geoLocationFormatException) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.Location_Error, (String)Messages.Location_FormatError);
                return false;
            }
        } else {
            location = new GeoLocation(type == 2);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setGeolocation(location);
        md.setPostalAddress(new PostalAddress(this.country.getText().trim(), this.city.getText().trim(), this.streetAddress.getText().trim(), this.postcode.getText().trim()));
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.Location_JobName, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Location_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Location.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.radioTypeUndefined.setSelection(true);
        this.radioTypeManual.setSelection(false);
        this.radioTypeAuto.setSelection(false);
        this.latitude.setText("");
        this.latitude.setEnabled(false);
        this.longitude.setText("");
        this.longitude.setEnabled(false);
    }
}

