/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.InetAddressListElement;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptSelector;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.AddAddressListElementDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.AddressListElementComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.DiscoveryConfig;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class NetworkDiscoveryConfigurator
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.NetworkDiscoveryConfigurator";
    private DiscoveryConfig config;
    private boolean modified = false;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Button radioDiscoveryOff;
    private Button radioDiscoveryPassive;
    private Button radioDiscoveryActive;
    private Button checkUseSnmpTraps;
    private Button checkUseSyslog;
    private Button radioFilterOff;
    private Button radioFilterCustom;
    private Button radioFilterAuto;
    private ScriptSelector filterScript;
    private Button checkAgentOnly;
    private Button checkSnmpOnly;
    private Button checkRangeOnly;
    private TableViewer filterAddressList;
    private TableViewer activeDiscoveryAddressList;
    private Action actionSave;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(this.getSite().getShell().getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        Messages.get();
        this.form.setText(Messages.NetworkDiscoveryConfigurator_FormTitle);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        this.createGeneralSection();
        this.createFilterSection();
        this.createActiveDiscoverySection();
        this.createSubnetFilterSection();
        this.createActions();
        this.contributeToActionBars();
        Messages.get();
        new ConsoleJob(Messages.NetworkDiscoveryConfigurator_LoadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final DiscoveryConfig loadedConfig = DiscoveryConfig.load();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkDiscoveryConfigurator.this.setConfig(loadedConfig);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkDiscoveryConfigurator_LoadJobError;
            }
        }.start();
    }

    private void createActions() {
        Messages.get();
        this.actionSave = new Action(Messages.NetworkDiscoveryConfigurator_Save, SharedIcons.SAVE){

            public void run() {
                NetworkDiscoveryConfigurator.this.save();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    private void createGeneralSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        Messages.get();
        section.setText(Messages.NetworkDiscoveryConfigurator_SectionGeneral);
        Messages.get();
        section.setDescription(Messages.NetworkDiscoveryConfigurator_SectionGeneralDescr);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.setModified();
                if (NetworkDiscoveryConfigurator.this.radioDiscoveryOff.getSelection()) {
                    NetworkDiscoveryConfigurator.this.config.setEnabled(false);
                } else {
                    NetworkDiscoveryConfigurator.this.config.setEnabled(true);
                    NetworkDiscoveryConfigurator.this.config.setActive(NetworkDiscoveryConfigurator.this.radioDiscoveryActive.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        Messages.get();
        this.radioDiscoveryOff = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_Disabled, 16);
        this.radioDiscoveryOff.addSelectionListener(listener);
        Messages.get();
        this.radioDiscoveryPassive = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_PassiveDiscovery, 16);
        this.radioDiscoveryPassive.addSelectionListener(listener);
        Messages.get();
        this.radioDiscoveryActive = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_ActiveDiscovery, 16);
        this.radioDiscoveryActive.addSelectionListener(listener);
        Messages.get();
        this.checkUseSnmpTraps = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_UseSNMPTrapsForDiscovery, 32);
        this.checkUseSnmpTraps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.config.setUseSnmpTraps(NetworkDiscoveryConfigurator.this.checkUseSnmpTraps.getSelection());
                NetworkDiscoveryConfigurator.this.setModified();
            }
        });
        GridData gd = new GridData();
        gd.verticalIndent = 10;
        this.checkUseSnmpTraps.setLayoutData((Object)gd);
        Messages.get();
        this.checkUseSyslog = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_UseSyslogForDiscovery, 32);
        this.checkUseSyslog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.config.setUseSyslog(NetworkDiscoveryConfigurator.this.checkUseSyslog.getSelection());
                NetworkDiscoveryConfigurator.this.setModified();
            }
        });
    }

    private void createFilterSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        Messages.get();
        section.setText(Messages.NetworkDiscoveryConfigurator_SectionFilter);
        Messages.get();
        section.setDescription(Messages.NetworkDiscoveryConfigurator_SectionFilterDescr);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        SelectionListener radioButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.updateElementEnablement();
                NetworkDiscoveryConfigurator.this.setModified();
                if (NetworkDiscoveryConfigurator.this.radioFilterOff.getSelection()) {
                    NetworkDiscoveryConfigurator.this.config.setFilter("none");
                } else if (NetworkDiscoveryConfigurator.this.radioFilterAuto.getSelection()) {
                    NetworkDiscoveryConfigurator.this.config.setFilter("auto");
                } else {
                    NetworkDiscoveryConfigurator.this.config.setFilter(NetworkDiscoveryConfigurator.this.filterScript.getScriptName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        SelectionListener checkBoxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.setModified();
                int flags = 0;
                if (NetworkDiscoveryConfigurator.this.checkAgentOnly.getSelection()) {
                    flags |= 1;
                }
                if (NetworkDiscoveryConfigurator.this.checkSnmpOnly.getSelection()) {
                    flags |= 2;
                }
                if (NetworkDiscoveryConfigurator.this.checkRangeOnly.getSelection()) {
                    flags |= 4;
                }
                NetworkDiscoveryConfigurator.this.config.setFilterFlags(flags);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        Messages.get();
        this.radioFilterOff = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_NoFiltering, 16);
        this.radioFilterOff.addSelectionListener(radioButtonListener);
        Messages.get();
        this.radioFilterCustom = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_CustomScript, 16);
        this.radioFilterCustom.addSelectionListener(radioButtonListener);
        this.filterScript = new ScriptSelector(clientArea, 0, true, false);
        this.toolkit.adapt((Composite)this.filterScript);
        this.filterScript.getTextControl().setBackground(clientArea.getBackground());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.filterScript.setLayoutData((Object)gd);
        this.filterScript.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NetworkDiscoveryConfigurator.this.radioFilterCustom.getSelection()) {
                    NetworkDiscoveryConfigurator.this.setModified();
                    NetworkDiscoveryConfigurator.this.config.setFilter(NetworkDiscoveryConfigurator.this.filterScript.getScriptName());
                }
            }
        });
        Messages.get();
        this.radioFilterAuto = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_AutoScript, 16);
        this.radioFilterAuto.addSelectionListener(radioButtonListener);
        Messages.get();
        this.checkAgentOnly = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_AcceptAgent, 32);
        this.checkAgentOnly.addSelectionListener(checkBoxListener);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.checkAgentOnly.setLayoutData((Object)gd);
        Messages.get();
        this.checkSnmpOnly = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_AcceptSNMP, 32);
        this.checkSnmpOnly.addSelectionListener(checkBoxListener);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.checkSnmpOnly.setLayoutData((Object)gd);
        Messages.get();
        this.checkRangeOnly = this.toolkit.createButton(clientArea, Messages.NetworkDiscoveryConfigurator_AcceptRange, 32);
        this.checkRangeOnly.addSelectionListener(checkBoxListener);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.checkRangeOnly.setLayoutData((Object)gd);
    }

    private void createActiveDiscoverySection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        Messages.get();
        section.setText(Messages.NetworkDiscoveryConfigurator_SectionActiveDiscoveryTargets);
        Messages.get();
        section.setDescription(Messages.NetworkDiscoveryConfigurator_SectionActiveDiscoveryTargetsDescr);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.activeDiscoveryAddressList = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.activeDiscoveryAddressList.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        gd.heightHint = 100;
        this.activeDiscoveryAddressList.getTable().setLayoutData((Object)gd);
        this.activeDiscoveryAddressList.getTable().setSortDirection(128);
        this.activeDiscoveryAddressList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.activeDiscoveryAddressList.setComparator((ViewerComparator)new AddressListElementComparator());
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.NetworkDiscoveryConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.addTargetAddressListElement();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.NetworkDiscoveryConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.removeTargetAddressListElements();
            }
        });
    }

    private void createSubnetFilterSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        Messages.get();
        section.setText(Messages.NetworkDiscoveryConfigurator_SectionAddressFilters);
        Messages.get();
        section.setDescription(Messages.NetworkDiscoveryConfigurator_SectionAddressFiltersDescr);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.filterAddressList = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.filterAddressList.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        gd.heightHint = 100;
        this.filterAddressList.getTable().setLayoutData((Object)gd);
        this.filterAddressList.getTable().setSortDirection(128);
        this.filterAddressList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.filterAddressList.setComparator((ViewerComparator)new AddressListElementComparator());
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.NetworkDiscoveryConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.addAddressFilterElement();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.NetworkDiscoveryConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.removeAddressFilterElements();
            }
        });
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void setConfig(DiscoveryConfig config) {
        this.config = config;
        this.radioDiscoveryOff.setSelection(!config.isEnabled());
        this.radioDiscoveryPassive.setSelection(config.isEnabled() && !config.isActive());
        this.radioDiscoveryActive.setSelection(config.isEnabled() && config.isActive());
        this.checkUseSnmpTraps.setSelection(config.isUseSnmpTraps());
        this.checkUseSyslog.setSelection(config.isUseSyslog());
        if (config.getFilter().equalsIgnoreCase("none") || config.getFilter().isEmpty()) {
            this.radioFilterOff.setSelection(true);
        } else if (config.getFilter().equalsIgnoreCase("auto")) {
            this.radioFilterAuto.setSelection(true);
        } else {
            this.radioFilterCustom.setSelection(true);
            this.filterScript.setScriptName(config.getFilter());
        }
        this.checkAgentOnly.setSelection((config.getFilterFlags() & 1) != 0);
        this.checkSnmpOnly.setSelection((config.getFilterFlags() & 2) != 0);
        this.checkRangeOnly.setSelection((config.getFilterFlags() & 4) != 0);
        this.activeDiscoveryAddressList.setInput((Object)config.getTargets().toArray());
        this.filterAddressList.setInput((Object)config.getAddressFilter().toArray());
        this.updateElementEnablement();
        this.modified = false;
        this.firePropertyChange(257);
    }

    private void updateElementEnablement() {
        if (this.radioFilterOff.getSelection()) {
            this.filterScript.setEnabled(false);
            this.checkAgentOnly.setEnabled(false);
            this.checkSnmpOnly.setEnabled(false);
            this.checkRangeOnly.setEnabled(false);
        } else if (this.radioFilterAuto.getSelection()) {
            this.filterScript.setEnabled(false);
            this.checkAgentOnly.setEnabled(true);
            this.checkSnmpOnly.setEnabled(true);
            this.checkRangeOnly.setEnabled(true);
        }
        if (this.radioFilterCustom.getSelection()) {
            this.filterScript.setEnabled(true);
            this.checkAgentOnly.setEnabled(false);
            this.checkSnmpOnly.setEnabled(false);
            this.checkRangeOnly.setEnabled(false);
        }
    }

    private void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.config.save();
        }
        catch (Exception e) {
            Shell shell = this.getSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.NetworkDiscoveryConfigurator_Error, (String)String.format(Messages.NetworkDiscoveryConfigurator_SaveErrorText, e.getLocalizedMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void save() {
        Messages.get();
        new ConsoleJob(Messages.NetworkDiscoveryConfigurator_SaveJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NetworkDiscoveryConfigurator.this.config.save();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkDiscoveryConfigurator.this.modified = false;
                        NetworkDiscoveryConfigurator.this.firePropertyChange(257);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkDiscoveryConfigurator_SaveJobError;
            }
        }.start();
    }

    private void addTargetAddressListElement() {
        InetAddressListElement element;
        List<InetAddressListElement> list;
        AddAddressListElementDialog dlg = new AddAddressListElementDialog(this.getSite().getShell());
        if (dlg.open() == 0 && !(list = this.config.getTargets()).contains(element = dlg.getElement())) {
            list.add(element);
            this.activeDiscoveryAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void removeTargetAddressListElements() {
        List<InetAddressListElement> list = this.config.getTargets();
        IStructuredSelection selection = (IStructuredSelection)this.activeDiscoveryAddressList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.activeDiscoveryAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void addAddressFilterElement() {
        InetAddressListElement element;
        List<InetAddressListElement> list;
        AddAddressListElementDialog dlg = new AddAddressListElementDialog(this.getSite().getShell());
        if (dlg.open() == 0 && !(list = this.config.getAddressFilter()).contains(element = dlg.getElement())) {
            list.add(element);
            this.filterAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void removeAddressFilterElements() {
        List<InetAddressListElement> list = this.config.getAddressFilter();
        IStructuredSelection selection = (IStructuredSelection)this.filterAddressList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.filterAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }
}

