/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectview.widgets.AbstractObjectStatusMap;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class ObjectStatusRadialWidget
extends Canvas
implements PaintListener,
DisposeListener {
    private AbstractObject rootObject;
    private int maxLvl;
    private int leafObjectCount;
    private float leafObjectSize;
    private int diameter;
    private int centerX;
    private int centerY;
    private ColorCache cCache;
    private Map<Long, ObjectData> objects;
    protected Image chartImage = null;
    private List<ObjectPosition> objectMap = new ArrayList<ObjectPosition>();

    public ObjectStatusRadialWidget(Composite parent, AbstractObject rootObject, Collection<AbstractObject> objects) {
        super(parent, 4);
        this.rootObject = rootObject;
        this.objects = new HashMap<Long, ObjectData>();
        for (AbstractObject o : objects) {
            this.objects.put(o.getObjectId(), new ObjectData(o));
        }
        this.cCache = new ColorCache((Control)this);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.addPaintListener(this);
        this.addDisposeListener(this);
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (ObjectStatusRadialWidget.this.chartImage != null) {
                    ObjectStatusRadialWidget.this.chartImage.dispose();
                    ObjectStatusRadialWidget.this.chartImage = null;
                }
                ObjectStatusRadialWidget.this.refresh();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    public void refresh() {
        this.render();
        this.redraw();
    }

    private void render() {
        Point size = this.getSize();
        if (this.chartImage == null) {
            if (size.x <= 0 || size.y <= 0) {
                return;
            }
            this.chartImage = new Image((Device)this.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.chartImage);
        this.paint(gc);
        gc.dispose();
    }

    private String substring(String text, GC gc, int lineNum) {
        StringBuilder name = new StringBuilder("");
        int start = 0;
        int i = 0;
        while (i < lineNum) {
            String substr;
            int end = text.length();
            int nameL = gc.textExtent((String)substr, (int)3).x;
            substr = text.substring(start);
            int numOfCharToLeave = (this.diameter / 2 - 6) / (nameL / substr.length());
            if (numOfCharToLeave >= substr.length()) {
                numOfCharToLeave = substr.length() - 1;
            }
            int j = 0;
            while (nameL > this.diameter / 2 - 6) {
                String tmp;
                if (i + 1 == lineNum) {
                    tmp = substr.substring(0, numOfCharToLeave - j).toString();
                    tmp = String.valueOf(tmp) + "...";
                } else {
                    tmp = substr.substring(0, numOfCharToLeave - j).toString();
                }
                nameL = gc.textExtent((String)tmp, (int)3).x;
                end = numOfCharToLeave - j + start;
                ++j;
            }
            name.append(text.substring(start, end));
            if (end == text.length()) break;
            name.append(i + 1 == lineNum ? "..." : "\n");
            start = end;
            ++i;
        }
        return name.toString();
    }

    private float drawParts(GC gc, AbstractObject object, int lvl, float degree) {
        gc.setAlpha(255);
        float objectSize = 0.0f;
        AbstractObject[] abstractObjectArray = object.getChildsAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                float currObjsize;
                AbstractObject obj;
                block14: {
                    block13: {
                        obj = abstractObjectArray[n2];
                        currObjsize = 0.0f;
                        if (!AbstractObjectStatusMap.isContainerObject(obj)) break block13;
                        currObjsize = this.drawParts(gc, obj, lvl + 1, degree);
                        if (currObjsize != 0.0f) break block14;
                        if (this.objects != null) break block15;
                        currObjsize = this.leafObjectSize;
                        break block14;
                    }
                    if (this.objects != null && !this.objects.containsKey(obj.getObjectId())) break block15;
                    currObjsize = this.leafObjectSize;
                }
                int compensation = Integer.signum(Math.round(degree + currObjsize) - (Math.round(degree) + Math.round(currObjsize)));
                gc.setBackground(this.getDisplay().getSystemColor(1));
                gc.fillArc(this.centerX - this.diameter * lvl / 2 - 3, this.centerY - this.diameter * lvl / 2 - 3, this.diameter * lvl + 6, this.diameter * lvl + 6, Math.round(degree), Math.round(currObjsize) + compensation);
                gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()));
                gc.fillArc(this.centerX - this.diameter * lvl / 2, this.centerY - this.diameter * lvl / 2, this.diameter * lvl, this.diameter * lvl, Math.round(degree), Math.round(currObjsize) - 1 + compensation);
                this.objectMap.add(new ObjectPosition(degree, degree + currObjsize, lvl, obj));
                Transform oldTransform = new Transform(gc.getDevice());
                gc.getTransform(oldTransform);
                String text = obj.getObjectName();
                Transform tr = new Transform((Device)this.getDisplay());
                tr.translate((float)this.centerX, (float)this.centerY);
                float rotate = 0.0f;
                float middle = degree + currObjsize / 2.0f;
                if (middle >= 90.0f && middle < 180.0f) {
                    rotate = 90.0f - (middle - 90.0f);
                }
                if (middle >= 270.0f && middle <= 360.0f) {
                    rotate = 90.0f - (middle - 270.0f);
                }
                if (middle >= 0.0f && middle < 90.0f) {
                    rotate = -middle;
                }
                if (middle >= 180.0f && middle < 270.0f) {
                    rotate = -(middle - 180.0f);
                }
                tr.rotate(rotate);
                gc.setTransform(tr);
                int l = gc.textExtent((String)text, (int)3).x;
                int h = gc.textExtent((String)text, (int)3).y;
                int high = (int)(Math.tan(currObjsize / 2.0f) * (double)(this.diameter * lvl / 2) * 2.0) - 6;
                int lineNum = high / (h + 13);
                if (lineNum < 0 || lineNum > 3) {
                    lineNum = 3;
                }
                if (l > this.diameter / 2 - 6) {
                    text = this.substring(text, gc, lineNum);
                }
                h = gc.textExtent((String)text, (int)3).y;
                gc.setForeground(ColorConverter.selectTextColorByBackgroundColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()), (ColorCache)this.cCache));
                if (middle >= 90.0f && middle <= 180.0f || middle > 180.0f && middle < 270.0f) {
                    l = gc.textExtent((String)text, (int)3).x;
                    gc.drawText(text, -(this.diameter * (lvl - 1)) / 2 - 6 - l, -h / 2, 3);
                } else {
                    gc.drawText(text, this.diameter * (lvl - 1) / 2 + 5, -h / 2, 3);
                }
                gc.setTransform(oldTransform);
                tr.dispose();
                oldTransform.dispose();
                degree += currObjsize;
                objectSize += currObjsize;
            }
            ++n2;
        }
        return objectSize;
    }

    private int calculateMaxLVLAndObjCount(AbstractObject object, int lvl) {
        AbstractObject[] objSet;
        int objcoutn = 0;
        int contFound = 0;
        AbstractObject[] abstractObjectArray = objSet = object.getChildsAsArray();
        int n = objSet.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject obj = abstractObjectArray[n2];
            if (this.objects != null) {
                if (AbstractObjectStatusMap.isContainerObject(obj)) {
                    int tmp = this.calculateMaxLVLAndObjCount(obj, lvl + 1);
                    if (tmp > 0) {
                        ++contFound;
                        objcoutn += tmp;
                    }
                } else if (this.objects.containsKey(obj.getObjectId())) {
                    ++objcoutn;
                }
            } else if (AbstractObjectStatusMap.isContainerObject(obj)) {
                objcoutn += this.calculateMaxLVLAndObjCount(obj, lvl + 1);
                ++contFound;
            } else {
                ++objcoutn;
            }
            ++n2;
        }
        if (this.objects == null && AbstractObjectStatusMap.isContainerObject(object) && objcoutn == 0) {
            ++objcoutn;
        }
        if (contFound == 0 && this.maxLvl < lvl) {
            this.maxLvl = lvl;
        }
        return objcoutn;
    }

    public void paintControl(PaintEvent e) {
        if (this.chartImage != null) {
            e.gc.drawImage(this.chartImage, 0, 0);
        }
    }

    public void paint(GC gc) {
        gc.setAdvanced(true);
        if (!gc.getAdvanced()) {
            gc.drawText("Advanced graphics not supported", 30, 30, true);
            return;
        }
        this.objectMap.clear();
        this.leafObjectCount = this.calculateMaxLVLAndObjCount(this.rootObject, 1);
        this.leafObjectSize = 360.0f / (float)this.leafObjectCount;
        Rectangle rect = this.getClientArea();
        --rect.width;
        --rect.height;
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        gc.setForeground(SharedColors.getColor((String)"Text.Normal", (Display)this.getDisplay()));
        gc.setLineWidth(1);
        int rectSide = Math.min(rect.width, rect.height);
        this.diameter = rectSide / (this.maxLvl + 1);
        this.centerX = rect.x + rectSide / 2;
        this.centerY = rect.y + rectSide / 2;
        this.drawParts(gc, this.rootObject, 2, 0.0f);
        gc.setBackground(this.getDisplay().getSystemColor(1));
        gc.setAlpha(255);
        gc.fillOval(this.centerX - this.diameter / 2 - 3, this.centerY - this.diameter / 2 - 3, this.diameter + 6, this.diameter + 6);
        gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.rootObject.getStatus()));
        gc.setAlpha(255);
        gc.fillOval(this.centerX - this.diameter / 2, this.centerY - this.diameter / 2, this.diameter, this.diameter);
        String text = this.rootObject instanceof AbstractNode ? String.valueOf(this.rootObject.getObjectName()) + "\n" + ((AbstractNode)this.rootObject).getPrimaryIP().getHostAddress() : this.rootObject.getObjectName();
        gc.setClipping(rect);
        int h = gc.textExtent((String)text, (int)3).y;
        int l = gc.textExtent((String)text, (int)3).x;
        gc.setForeground(ColorConverter.selectTextColorByBackgroundColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)this.rootObject.getStatus()), (ColorCache)this.cCache));
        gc.drawText(text, rect.x + rectSide / 2 - l / 2, rect.y + rectSide / 2 - h / 2, 3);
        this.objectMap.add(new ObjectPosition(0.0f, 360.0f, 1, this.rootObject));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.maxLvl == 0) {
            this.calculateMaxLVLAndObjCount(this.rootObject, 1);
        }
        return new Point(240 * this.maxLvl, 240 * this.maxLvl);
    }

    protected void updateObjects(AbstractObject rootObject, Collection<AbstractObject> objects) {
        this.rootObject = rootObject;
        this.objects.clear();
        for (AbstractObject o : objects) {
            this.objects.put(o.getObjectId(), new ObjectData(o));
        }
        this.redraw();
    }

    protected boolean containsObject(long id) {
        return this.rootObject.getObjectId() == id || this.objects.containsKey(id);
    }

    protected boolean containsChangedObject(AbstractObject object) {
        if (this.rootObject.getObjectId() == object.getObjectId()) {
            return true;
        }
        ObjectData d = this.objects.get(object.getObjectId());
        return d != null ? d.isChanged(object) : false;
    }

    public AbstractObject getObjectFromPoint(int x, int y) {
        AbstractObject object = null;
        int clickLvl = (int)(Math.sqrt(Math.pow(x - this.centerX, 2.0) + Math.pow(y - this.centerY, 2.0)) / (double)(this.diameter / 2) + 1.0);
        double clickDegree = Math.toDegrees(Math.atan2(this.centerX - x, this.centerY - y));
        if ((clickDegree += 90.0) < 0.0) {
            clickDegree += 360.0;
        }
        ObjectPosition curr = new ObjectPosition((float)clickDegree, (float)clickDegree, clickLvl, null);
        for (ObjectPosition p : this.objectMap) {
            if (!p.equals(curr)) continue;
            object = p.getObject();
            break;
        }
        return object;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.chartImage != null) {
            this.chartImage.dispose();
        }
    }

    private class ObjectData {
        private String name;
        private ObjectStatus status;
        private long[] children;

        public ObjectData(AbstractObject object) {
            this.name = object.getObjectName();
            this.status = object.getStatus();
            this.children = AbstractObjectStatusMap.isContainerObject(object) ? object.getChildIdList() : null;
        }

        public boolean isChanged(AbstractObject object) {
            return this.status != object.getStatus() || !this.name.equals(object.getObjectName()) || AbstractObjectStatusMap.isContainerObject(object) && !Arrays.equals(this.children, object.getChildIdList());
        }
    }

    class ObjectPosition {
        float startDegree;
        float endDegree;
        int lvl;
        AbstractObject obj;

        public ObjectPosition(float startDegree, float endDegree, int lvl, AbstractObject obj) {
            this.startDegree = startDegree;
            this.endDegree = endDegree;
            this.lvl = lvl;
            this.obj = obj;
        }

        public AbstractObject getObject() {
            return this.obj;
        }

        public boolean equals(Object arg0) {
            if (((ObjectPosition)arg0).lvl != this.lvl) {
                return false;
            }
            return ((ObjectPosition)arg0).startDegree >= this.startDegree && ((ObjectPosition)arg0).endDegree <= this.endDegree;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.startDegree) + this.lvl;
        }
    }
}

