/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import java.net.InetAddress;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.dialogs.IPAddressSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class IPAddressSelector
extends AbstractSelector {
    private AbstractNode node;
    private InetAddress address;
    private NXCSession session;

    public IPAddressSelector(Composite parent, int style) {
        super(parent, style, 4);
        Messages.get();
        this.setText(Messages.IPAddressSelector_None);
        this.session = ConsoleSharedData.getSession();
    }

    public void setNode(long nodeId) {
        AbstractObject object = this.session.findObjectById(nodeId);
        if (object instanceof AbstractNode) {
            this.node = (AbstractNode)object;
            this.address = this.node.getPrimaryIP().getAddress();
            this.setText(this.address != null ? this.address.getHostAddress() : "");
        } else {
            this.node = null;
            Messages.get();
            this.setText(Messages.IPAddressSelector_None);
        }
    }

    public void setNode(AbstractNode node) {
        this.node = node;
        this.address = node.getPrimaryIP().getAddress();
        this.setText(this.address != null ? this.address.getHostAddress() : "");
    }

    protected void selectionButtonHandler() {
        IPAddressSelectionDialog dlg = new IPAddressSelectionDialog(this.getShell(), this.node);
        if (dlg.open() == 0) {
            this.address = dlg.getAddress();
            this.setText(this.address.getHostAddress());
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }
}

