/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectview.widgets.AbstractObjectStatusMap;
import org.netxms.ui.eclipse.objectview.widgets.ObjectPopupDialog;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusRadialWidget;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ObjectStatusMapRadial
extends AbstractObjectStatusMap {
    private ObjectStatusRadialWidget widget;
    private AbstractObject tooltipObject = null;
    private ObjectPopupDialog tooltipDialog = null;

    public ObjectStatusMapRadial(IViewPart viewPart, Composite parent, int style, boolean allowFilterClose) {
        super(viewPart, parent, style, allowFilterClose);
    }

    protected Collection<AbstractObject> createFilteredList(AbstractObject root) {
        HashMap<Long, AbstractObject> acceptedlist = new HashMap<Long, AbstractObject>();
        for (AbstractObject obj : root.getAllChilds(-1)) {
            if (!ObjectStatusMapRadial.isContainerObject(obj) && !ObjectStatusMapRadial.isLeafObject(obj) || !this.isAcceptedByFilter(obj)) continue;
            acceptedlist.put(obj.getObjectId(), obj);
        }
        return acceptedlist.values();
    }

    @Override
    public void refresh() {
        AbstractObject root = this.session.findObjectById(this.rootObjectId);
        Collection<AbstractObject> objects = this.createFilteredList(root);
        if (this.widget == null) {
            this.widget = new ObjectStatusRadialWidget(this.dataArea, root, objects);
            this.widget.setLayoutData(new GridData(4, 4, true, true));
            this.widget.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    if (ObjectStatusMapRadial.this.tooltipDialog != null && ObjectStatusMapRadial.this.tooltipDialog.getShell() != null && !ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != ObjectStatusMapRadial.this.tooltipDialog.getShell()) {
                        ObjectStatusMapRadial.this.tooltipDialog.close();
                        ObjectStatusMapRadial.this.tooltipDialog = null;
                    }
                    ObjectStatusMapRadial.this.tooltipObject = null;
                    AbstractObject object = ObjectStatusMapRadial.this.widget.getObjectFromPoint(e.x, e.y);
                    if (object != null) {
                        ObjectStatusMapRadial.this.setSelection((ISelection)new StructuredSelection((Object)object));
                        if (e.button == 1) {
                            ObjectStatusMapRadial.this.callDetailsProvider(object);
                        }
                    } else {
                        ObjectStatusMapRadial.this.setSelection((ISelection)new StructuredSelection());
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            WidgetHelper.attachMouseTrackListener((Composite)this.widget, (MouseTrackListener)new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                    AbstractObject object = ObjectStatusMapRadial.this.widget.getObjectFromPoint(e.x, e.y);
                    if (object != null && (object != ObjectStatusMapRadial.this.tooltipObject || ObjectStatusMapRadial.this.tooltipDialog == null || ObjectStatusMapRadial.this.tooltipDialog.getShell() == null || ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed())) {
                        if (ObjectStatusMapRadial.this.tooltipDialog != null && ObjectStatusMapRadial.this.tooltipDialog.getShell() != null && !ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed()) {
                            ObjectStatusMapRadial.this.tooltipDialog.close();
                        }
                        ObjectStatusMapRadial.this.tooltipObject = object;
                        ObjectStatusMapRadial.this.tooltipDialog = new ObjectPopupDialog(ObjectStatusMapRadial.this.getShell(), object, ObjectStatusMapRadial.this.widget.toDisplay(e.x, e.y));
                        ObjectStatusMapRadial.this.tooltipDialog.open();
                    } else if (object == null && ObjectStatusMapRadial.this.tooltipDialog != null && ObjectStatusMapRadial.this.tooltipDialog.getShell() != null && !ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed()) {
                        ObjectStatusMapRadial.this.tooltipDialog.close();
                        ObjectStatusMapRadial.this.tooltipDialog = null;
                    }
                }

                public void mouseExit(MouseEvent e) {
                    if (ObjectStatusMapRadial.this.tooltipDialog != null && ObjectStatusMapRadial.this.tooltipDialog.getShell() != null && !ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != ObjectStatusMapRadial.this.tooltipDialog.getShell()) {
                        ObjectStatusMapRadial.this.tooltipDialog.close();
                        ObjectStatusMapRadial.this.tooltipDialog = null;
                    }
                    ObjectStatusMapRadial.this.tooltipObject = null;
                }

                public void mouseEnter(MouseEvent e) {
                }
            });
            Menu menu = this.menuManager.createContextMenu((Control)this.widget);
            this.widget.setMenu(menu);
            if (this.viewPart != null) {
                this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this);
            }
        } else {
            this.widget.updateObjects(root, objects);
            this.widget.refresh();
        }
        this.dataArea.layout(true, true);
        Rectangle r = this.getClientArea();
        this.scroller.setMinSize(this.dataArea.computeSize(r.width, -1));
        for (Runnable l : this.refreshListeners) {
            l.run();
        }
    }

    @Override
    protected void onObjectChange(AbstractObject object) {
        if (this.widget.containsChangedObject(object) || object.isChildOf(this.rootObjectId) && this.isAcceptedByFilter(object)) {
            this.refreshTimer.execute();
        }
    }

    @Override
    protected void onObjectDelete(long objectId) {
        if (this.widget.containsObject(objectId)) {
            this.refreshTimer.execute();
        }
    }
}

