/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.users;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.NXCPMessage;

public abstract class AbstractUserObject {
    public static final int MODIFIED = 1;
    public static final int DELETED = 2;
    public static final int DISABLED = 4;
    public static final int CHANGE_PASSWORD = 8;
    public static final int CANNOT_CHANGE_PASSWORD = 16;
    public static final int INTRUDER_LOCKOUT = 32;
    public static final int PASSWORD_NEVER_EXPIRES = 64;
    public static final int LDAP_USER = 128;
    public static final int SYNC_EXCEPTION = 256;
    public static final int CLOSE_OTHER_SESSIONS = 512;
    public static final int MODIFY_LOGIN_NAME = 1;
    public static final int MODIFY_DESCRIPTION = 2;
    public static final int MODIFY_FULL_NAME = 4;
    public static final int MODIFY_FLAGS = 8;
    public static final int MODIFY_ACCESS_RIGHTS = 16;
    public static final int MODIFY_MEMBERS = 32;
    public static final int MODIFY_CERT_MAPPING = 64;
    public static final int MODIFY_AUTH_METHOD = 128;
    public static final int MODIFY_PASSWD_LENGTH = 256;
    public static final int MODIFY_TEMP_DISABLE = 512;
    public static final int MODIFY_CUSTOM_ATTRIBUTES = 1024;
    public static final int MODIFY_XMPP_ID = 2048;
    public static final int MODIFY_GROUP_MEMBERSHIP = 4096;
    protected long id;
    protected String name;
    protected UUID guid;
    protected long systemRights;
    protected int flags;
    protected String description;
    protected String ldapDn;
    protected String ldapId;
    protected Map<String, String> customAttributes = new HashMap<String, String>(0);

    public AbstractUserObject(String name) {
        this.name = name;
        this.description = "";
        this.guid = UUID.randomUUID();
    }

    public AbstractUserObject(AbstractUserObject src) {
        this.id = src.id;
        this.name = new String(src.name);
        this.guid = UUID.fromString(src.guid.toString());
        this.systemRights = src.systemRights;
        this.flags = src.flags;
        this.description = src.description;
        this.ldapDn = src.ldapDn;
        this.ldapId = src.ldapId;
        this.customAttributes = new HashMap<String, String>(0);
        for (Map.Entry<String, String> e : src.customAttributes.entrySet()) {
            this.customAttributes.put(new String(e.getKey()), new String(e.getValue()));
        }
    }

    public AbstractUserObject(NXCPMessage msg) {
        this.id = msg.getFieldAsInt64(35L);
        this.name = msg.getFieldAsString(34L);
        this.flags = msg.getFieldAsInt32(37L);
        this.systemRights = msg.getFieldAsInt64(36L);
        this.description = msg.getFieldAsString(41L);
        this.guid = msg.getFieldAsUUID(222L);
        this.ldapDn = msg.getFieldAsString(551L);
        this.ldapId = msg.getFieldAsString(552L);
        int count = msg.getFieldAsInt32(309L);
        long varId = 0x70000000L;
        int i = 0;
        while (i < count) {
            String name = msg.getFieldAsString(varId++);
            String value = msg.getFieldAsString(varId++);
            this.customAttributes.put(name, value);
            ++i;
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(35L, (int)this.id);
        msg.setField(34L, this.name);
        msg.setFieldInt16(37L, this.flags);
        msg.setFieldInt64(36L, this.systemRights);
        msg.setField(41L, this.description);
        msg.setFieldInt32(309L, this.customAttributes.size());
        long varId = 0x70000000L;
        for (Map.Entry<String, String> e : this.customAttributes.entrySet()) {
            msg.setField(varId++, e.getKey());
            msg.setField(varId++, e.getValue());
        }
    }

    public boolean isDeleted() {
        return (this.flags & 2) == 2;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public String getLdapDn() {
        return this.ldapDn;
    }

    public String getLdapId() {
        return this.ldapId;
    }

    public long getSystemRights() {
        return this.systemRights;
    }

    public void setSystemRights(long systemRights) {
        this.systemRights = systemRights;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCustomAttribute(String name) {
        return this.customAttributes.get(name);
    }

    public void setCustomAttribute(String name, String value) {
        this.customAttributes.put(name, value);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isDisabled() {
        return (this.flags & 4) == 4;
    }

    public boolean isPasswordChangeNeeded() {
        return (this.flags & 8) == 8;
    }

    public boolean isPasswordChangeForbidden() {
        return (this.flags & 0x10) == 16;
    }
}

