/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.widgets.internal;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class StyledTextContentAdapter
implements IControlContentAdapter {
    public String getControlContents(Control control) {
        return ((StyledText)control).getText();
    }

    public int getCursorPosition(Control control) {
        return ((StyledText)control).getCaretOffset();
    }

    public Rectangle getInsertionBounds(Control control) {
        StyledText text = (StyledText)control;
        Point caretOrigin = text.getLocationAtOffset(text.getCaretOffset());
        return new Rectangle(caretOrigin.x + text.getClientArea().x, caretOrigin.y + text.getClientArea().y + 3, 1, text.getLineHeight());
    }

    public void insertControlContents(Control control, String contents, int cursorPosition) {
        StyledText text = (StyledText)control;
        text.insert(contents);
        text.setCaretOffset(text.getCaretOffset() + cursorPosition);
    }

    public void setControlContents(Control control, String contents, int cursorPosition) {
        StyledText text = (StyledText)control;
        text.setText(contents);
        text.setCaretOffset(cursorPosition);
    }

    public void setCursorPosition(Control control, int index) {
        ((StyledText)control).setCaretOffset(index);
    }
}

