/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.api;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum GaugeColorMode {
    ZONE(0),
    CUSTOM(1),
    THRESHOLD(2);

    private int value;
    private static Map<Integer, GaugeColorMode> lookupTable;

    static {
        lookupTable = new HashMap<Integer, GaugeColorMode>();
        GaugeColorMode[] gaugeColorModeArray = GaugeColorMode.values();
        int n = gaugeColorModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GaugeColorMode element = gaugeColorModeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private GaugeColorMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static GaugeColorMode getByValue(int value) {
        GaugeColorMode element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)GaugeColorMode.class.getName(), (String)("Unknown element " + value));
            return ZONE;
        }
        return element;
    }
}

