/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._threading;

import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._threading.Condition$Condition__is_owned_exposer;
import org.python.modules._threading.Condition$Condition_notify_all_exposer;
import org.python.modules._threading.Condition$Condition_wait_exposer;
import org.python.modules._threading.ConditionSupportingLock;
import org.python.modules._threading.RLock;

@ExposedType(name="_threading.Condition")
public class Condition
extends PyObject
implements ContextManager,
Traverseproc {
    public static final PyType TYPE;
    private final ConditionSupportingLock _lock;
    private final java.util.concurrent.locks.Condition _condition;

    public Condition() {
        this(new RLock());
    }

    public Condition(ConditionSupportingLock lock) {
        this._lock = lock;
        this._condition = lock.getLock().newCondition();
    }

    @ExposedNew
    static final PyObject Condition___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int nargs = args.length;
        if (nargs == 1) {
            return new Condition((ConditionSupportingLock)((Object)args[0]));
        }
        return new Condition();
    }

    public boolean acquire() {
        return this.Condition_acquire(true);
    }

    public boolean acquire(boolean blocking) {
        return this.Condition_acquire(blocking);
    }

    final boolean Condition_acquire(boolean blocking) {
        return this._lock.acquire(blocking);
    }

    @Override
    public PyObject __enter__(ThreadState ts) {
        this._lock.acquire();
        return this;
    }

    final PyObject Condition___enter__() {
        this.Condition_acquire(true);
        return this;
    }

    public void release() {
        this.Condition_release();
    }

    final void Condition_release() {
        this._lock.release();
    }

    @Override
    public boolean __exit__(ThreadState ts, PyException exception) {
        this._lock.release();
        return false;
    }

    final boolean Condition___exit__(PyObject type, PyObject value, PyObject traceback2) {
        this.Condition_release();
        return false;
    }

    public void wait$(PyObject timeout) throws InterruptedException {
        this.Condition_wait(timeout);
    }

    final void Condition_wait(PyObject timeout) throws InterruptedException {
        try {
            if (timeout == Py.None) {
                this._condition.await();
            } else {
                long nanos = (long)(timeout.asDouble() * 1.0E9);
                this._condition.awaitNanos(nanos);
            }
        }
        catch (IllegalMonitorStateException ex) {
            throw Py.RuntimeError("cannot wait on un-acquired lock");
        }
    }

    public void notify$() {
        this.Condition_notify(1);
    }

    final void Condition_notify(int count2) {
        try {
            for (int i = 0; i < count2; ++i) {
                this._condition.signal();
            }
        }
        catch (IllegalMonitorStateException ex) {
            throw Py.RuntimeError("cannot notify on un-acquired lock");
        }
    }

    public void notifyAll$() {
        this.Condition_notifyAll();
    }

    final void Condition_notifyAll() {
        try {
            this._condition.signalAll();
        }
        catch (IllegalMonitorStateException ex) {
            throw Py.RuntimeError("cannot notify on un-acquired lock");
        }
    }

    final void Condition_notify_all() {
        this._condition.signalAll();
    }

    public boolean _is_owned() {
        return this.Condition__is_owned();
    }

    final boolean Condition__is_owned() {
        return this._lock._is_owned();
    }

    @Override
    public String toString() {
        int count2 = 0;
        try {
            count2 = this._lock.getWaitQueueLength(this._condition);
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
        return Py.newString("<_threading.Condition(%s, %d)>").__mod__(new PyTuple(Py.newString(this._lock.toString()), Py.newInteger(count2))).toString();
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this._lock != null ? visit.visit((PyObject)((Object)this._lock), arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && this._lock == ob;
    }

    static {
        PyType.addBuilder(Condition.class, new Condition$PyExposer());
        TYPE = PyType.fromClass(Condition.class);
    }

    public class Condition$Condition_acquire_exposer
    extends PyBuiltinMethodNarrow {
        public Condition$Condition_acquire_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "";
        }

        public Condition$Condition_acquire_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new Condition$Condition_acquire_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((Condition)this.self).Condition_acquire(Py.py2boolean(pyObject)));
        }

        public PyObject __call__() {
            return Py.newBoolean(((Condition)this.self).Condition_acquire(true));
        }
    }

    public class Condition$Condition___enter___exposer
    extends PyBuiltinMethodNarrow {
        public Condition$Condition___enter___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public Condition$Condition___enter___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new Condition$Condition___enter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((Condition)this.self).Condition___enter__();
        }
    }

    public class Condition$Condition_release_exposer
    extends PyBuiltinMethodNarrow {
        public Condition$Condition_release_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public Condition$Condition_release_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new Condition$Condition_release_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((Condition)this.self).Condition_release();
            return Py.None;
        }
    }

    public class Condition$Condition___exit___exposer
    extends PyBuiltinMethodNarrow {
        public Condition$Condition___exit___exposer(String string2) {
            super(string2, 4, 4);
            this.doc = "";
        }

        public Condition$Condition___exit___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new Condition$Condition___exit___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newBoolean(((Condition)this.self).Condition___exit__(pyObject, pyObject2, pyObject3));
        }
    }

    public class Condition$Condition_notify_exposer
    extends PyBuiltinMethodNarrow {
        public Condition$Condition_notify_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "";
        }

        public Condition$Condition_notify_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new Condition$Condition_notify_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((Condition)this.self).Condition_notify(Py.py2int(pyObject));
            return Py.None;
        }

        public PyObject __call__() {
            ((Condition)this.self).Condition_notify(1);
            return Py.None;
        }
    }

    public class Condition$Condition_notifyAll_exposer
    extends PyBuiltinMethodNarrow {
        public Condition$Condition_notifyAll_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public Condition$Condition_notifyAll_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new Condition$Condition_notifyAll_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((Condition)this.self).Condition_notifyAll();
            return Py.None;
        }
    }

    public class Condition$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return Condition.Condition___new__(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class Condition$PyExposer
    extends BaseTypeBuilder {
        public Condition$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new Condition$Condition_acquire_exposer("acquire"), new Condition$Condition___enter___exposer("__enter__"), new Condition$Condition_release_exposer("release"), new Condition$Condition___exit___exposer("__exit__"), new Condition$Condition_wait_exposer("wait"), new Condition$Condition_notify_exposer("notify"), new Condition$Condition_notifyAll_exposer("notifyAll"), new Condition$Condition_notify_all_exposer("notify_all"), new Condition$Condition__is_owned_exposer("_is_owned")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("_threading.Condition", Condition.class, Object.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new Condition$exposed___new__());
        }
    }
}

