/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyInteger;
import org.python.core.PyIterator;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.islice$islice___init___exposer;
import org.python.modules.itertools.isliceDerived;
import org.python.modules.itertools.itertools;

@ExposedType(name="itertools.islice", base=PyObject.class, doc="islice(iterable, [start,] stop [, step]) --> islice object\n\nReturn an iterator whose next() method returns selected values from an\niterable.  If start is specified, will skip all preceding elements;\notherwise, start defaults to zero.  Step defaults to one.  If\nspecified as another value, step determines how many values are \nskipped between successive calls.  Works like a slice() on a list\nbut returns an iterator.")
public class islice
extends PyIterator {
    public static final PyType TYPE;
    private itertools.ItertoolsIterator iter;
    public static final String islice_doc = "islice(iterable, [start,] stop [, step]) --> islice object\n\nReturn an iterator whose next() method returns selected values from an\niterable.  If start is specified, will skip all preceding elements;\notherwise, start defaults to zero.  Step defaults to one.  If\nspecified as another value, step determines how many values are \nskipped between successive calls.  Works like a slice() on a list\nbut returns an iterator.";

    public islice() {
    }

    public islice(PyType subType) {
        super(subType);
    }

    public islice(PyObject iterable, PyObject stopObj) {
        this.islice___init__(iterable, new PyInteger(0), stopObj, new PyInteger(1));
    }

    public islice(PyObject iterable, PyObject start, PyObject stopObj) {
        this.islice___init__(iterable, start, stopObj, new PyInteger(1));
    }

    @ExposedNew
    final void islice___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("islice", args, kwds, new String[]{"iterable", "start", "stop", "step"}, 2);
        PyObject iterable = ap.getPyObject(0);
        if (args.length == 2) {
            PyObject stopObj = ap.getPyObject(1);
            this.islice___init__(iterable, new PyInteger(0), stopObj, new PyInteger(1));
        } else {
            PyObject startObj = ap.getPyObject(1);
            PyObject stopObj = ap.getPyObject(2);
            if (args.length == 3) {
                this.islice___init__(iterable, startObj, stopObj, new PyInteger(1));
            } else {
                PyObject stepObj = ap.getPyObject(3);
                this.islice___init__(iterable, startObj, stopObj, stepObj);
            }
        }
    }

    private void islice___init__(final PyObject iterable, PyObject startObj, PyObject stopObj, PyObject stepObj) {
        int stop;
        final int start = itertools.py2int(startObj, 0, "Start argument must be a non-negative integer or None");
        final int step = itertools.py2int(stepObj, 1, "Step argument must be a non-negative integer or None");
        int stopArg = itertools.py2int(stopObj, 0, "Stop argument must be a non-negative integer or None");
        int n = stop = stopObj instanceof PyNone ? Integer.MAX_VALUE : stopArg;
        if (start < 0 || step < 0 || stop < 0) {
            throw Py.ValueError("Indices for islice() must be non-negative integers");
        }
        if (step == 0) {
            throw Py.ValueError("Step must be one or larger for islice()");
        }
        this.iter = new itertools.ItertoolsIterator(){
            int counter;
            int lastCount;
            PyObject iter;
            {
                this.counter = start;
                this.lastCount = 0;
                this.iter = iterable.__iter__();
            }

            @Override
            public PyObject __iternext__() {
                PyObject result2 = null;
                while (this.lastCount < Math.min(this.counter + 1, stop)) {
                    result2 = this.nextElement(this.iter);
                    ++this.lastCount;
                }
                if (this.lastCount - 1 == this.counter) {
                    this.counter += step;
                    return result2;
                }
                return null;
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(islice.class, new islice$PyExposer());
        TYPE = PyType.fromClass(islice.class);
    }

    public class islice$next_exposer
    extends PyBuiltinMethodNarrow {
        public islice$next_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public islice$next_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new islice$next_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((islice)this.self).next();
        }
    }

    public class islice$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            islice islice2 = new islice(this.for_type);
            if (bl) {
                islice2.islice___init__(pyObjectArray, stringArray);
            }
            return islice2;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new isliceDerived(pyType);
        }
    }

    public class islice$PyExposer
    extends BaseTypeBuilder {
        public islice$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new islice$islice___init___exposer("__init__"), new islice$next_exposer("next")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("itertools.islice", islice.class, PyObject.class, true, "islice(iterable, [start,] stop [, step]) --> islice object\n\nReturn an iterator whose next() method returns selected values from an\niterable.  If start is specified, will skip all preceding elements;\notherwise, start defaults to zero.  Step defaults to one.  If\nspecified as another value, step determines how many values are \nskipped between successive calls.  Works like a slice() on a list\nbut returns an iterator.", pyBuiltinMethodArray, pyDataDescrArray, new islice$exposed___new__());
        }
    }
}

