/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.util.regex.Pattern;
import org.simpleframework.xml.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringArrayTransform
implements Transform<String[]> {
    private final Pattern pattern;
    private final String token;

    public StringArrayTransform() {
        this(",");
    }

    public StringArrayTransform(String token2) {
        this.pattern = Pattern.compile(token2);
        this.token = token2;
    }

    @Override
    public String[] read(String value) {
        return this.read(value, this.token);
    }

    private String[] read(String value, String token2) {
        String[] list = this.pattern.split(value);
        for (int i = 0; i < list.length; ++i) {
            String text2 = list[i];
            if (text2 == null) continue;
            list[i] = text2.trim();
        }
        return list;
    }

    @Override
    public String write(String[] list) {
        return this.write(list, this.token);
    }

    private String write(String[] list, String token2) {
        StringBuilder text2 = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            String item = list[i];
            if (item == null) continue;
            if (text2.length() > 0) {
                text2.append(token2);
                text2.append(' ');
            }
            text2.append(item);
        }
        return text2.toString();
    }
}

