/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionNotification;

public class SessionToken {
    private UUID guid;
    private NXCSession session;
    private long activityTimestamp;
    private LinkedBlockingQueue<SessionNotification> notificationQueue = new LinkedBlockingQueue(8192);

    public SessionToken(NXCSession session) {
        this.guid = UUID.randomUUID();
        this.activityTimestamp = System.currentTimeMillis();
        this.session = session;
    }

    public void updateActivityTimestamp() {
        this.activityTimestamp = System.currentTimeMillis();
    }

    public UUID getGuid() {
        return this.guid;
    }

    public NXCSession getSession() {
        return this.session;
    }

    public long getActivityTimestamp() {
        return this.activityTimestamp;
    }

    public void addNotificationToQueue(SessionNotification notification) {
        this.notificationQueue.offer(notification);
    }

    public SessionNotification pollNotificationQueue(long timeout) throws InterruptedException {
        return (SessionNotification)this.notificationQueue.poll(timeout, TimeUnit.SECONDS);
    }
}

