/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import org.json.JSONException;
import org.json.JSONObject;
import org.netxms.client.constants.RCC;
import org.netxms.websvc.WebSvcException;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Resource;
import org.restlet.service.StatusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebSvcStatusService
extends StatusService {
    private Logger log = LoggerFactory.getLogger(WebSvcStatusService.class);

    public Status toStatus(Throwable throwable, Request request, Response response) {
        if (throwable != null) {
            if (throwable instanceof WebSvcException) {
                this.log.info("Request processing error: " + throwable.getMessage());
                return new Status(WebSvcStatusService.getStatusFromRCC((int)((WebSvcException)throwable).getErrorCode()), throwable);
            }
            this.log.error("Exception in request handler", throwable);
        }
        return super.toStatus(throwable, request, response);
    }

    public Status toStatus(Throwable throwable, Resource resource) {
        if (throwable != null) {
            if (throwable instanceof WebSvcException) {
                this.log.info("Request processing error: " + throwable.getMessage());
                return new Status(WebSvcStatusService.getStatusFromRCC((int)((WebSvcException)throwable).getErrorCode()), throwable);
            }
            this.log.error("Exception in request handler", throwable);
        }
        return super.toStatus(throwable, resource);
    }

    public static Status getStatusFromRCC(int rcc) {
        switch (rcc) {
            case 2: {
                return Status.CLIENT_ERROR_UNAUTHORIZED;
            }
            case 17: {
                return Status.CLIENT_ERROR_METHOD_NOT_ALLOWED;
            }
            case 46: {
                return Status.SERVER_ERROR_INTERNAL;
            }
            case 0: {
                return Status.SUCCESS_OK;
            }
            case 7: 
            case 11: 
            case 14: 
            case 21: 
            case 22: 
            case 25: 
            case 29: 
            case 36: 
            case 48: 
            case 55: 
            case 56: 
            case 59: 
            case 63: 
            case 70: 
            case 79: 
            case 84: 
            case 94: 
            case 97: 
            case 99: 
            case 101: {
                return Status.CLIENT_ERROR_NOT_FOUND;
            }
            case 28: {
                return Status.SERVER_ERROR_NOT_IMPLEMENTED;
            }
            case 4: {
                return Status.CLIENT_ERROR_REQUEST_TIMEOUT;
            }
        }
        return Status.CLIENT_ERROR_BAD_REQUEST;
    }

    public static String getMessageFromRCC(int rcc) {
        return RCC.getText((int)rcc, (String)"en", null);
    }

    public Representation getRepresentation(Status status, Request request, Response response) {
        JSONObject json = new JSONObject();
        if (status.getThrowable() instanceof WebSvcException) {
            WebSvcException e = (WebSvcException)status.getThrowable();
            try {
                json.put("error", e.getErrorCode());
                json.put("description", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {}
        } else if (status.getThrowable() instanceof JSONException) {
            try {
                json.put("error", 12);
                json.put("description", (Object)status.getThrowable().getMessage());
            }
            catch (JSONException jSONException) {}
        } else {
            this.log.debug("Internal error", status.getThrowable());
            try {
                json.put("error", 46);
                json.put("description", (Object)(status.getThrowable() != null ? status.getThrowable().getMessage() : "Internal error"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return new StringRepresentation((CharSequence)json.toString(), MediaType.APPLICATION_JSON);
    }
}

