/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.views;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.client.objects.Node;
import org.netxms.client.server.AgentFile;
import org.netxms.client.server.ServerJobIdUpdater;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.filemanager.Activator;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.dialogs.CreateFolderDialog;
import org.netxms.ui.eclipse.filemanager.dialogs.StartClientToAgentFolderUploadDialog;
import org.netxms.ui.eclipse.filemanager.dialogs.StartClientToServerFileUploadDialog;
import org.netxms.ui.eclipse.filemanager.views.AgentFileViewer;
import org.netxms.ui.eclipse.filemanager.views.helpers.AgentFileComparator;
import org.netxms.ui.eclipse.filemanager.views.helpers.AgentFileFilter;
import org.netxms.ui.eclipse.filemanager.views.helpers.AgentFileLabelProvider;
import org.netxms.ui.eclipse.filemanager.views.helpers.ViewAgentFilesProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.jobs.ConsoleJobCallingServerJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.DialogData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class AgentFileManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.filemanager.views.AgentFileManager";
    private static final String TABLE_CONFIG_PREFIX = "AgentFileManager";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_SIZE = 2;
    public static final int COLUMN_MODIFYED = 3;
    public static final int COLUMN_OWNER = 4;
    public static final int COLUMN_GROUP = 5;
    public static final int COLUMN_ACCESS_RIGHTS = 6;
    private boolean initShowFilter = true;
    private Composite content;
    private AgentFileFilter filter;
    private FilterText filterText;
    private SortableTreeViewer viewer;
    private NXCSession session;
    private Action actionRefreshAll;
    private Action actionUploadFile;
    private Action actionUploadFolder;
    private Action actionDelete;
    private Action actionRename;
    private Action actionRefreshDirectory;
    private Action actionShowFilter;
    private Action actionDownloadFile;
    private Action actionTailFile;
    private Action actionShowFile;
    private Action actionCreateDirectory;
    private Action actionCalculateFolderSize;
    private Action actionCopyFilePath;
    private Action actionCopyFileName;
    private long objectId = 0L;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = AgentFileManager.safeCast(settings.get("AgentFileManager.showFilter"), settings.getBoolean("AgentFileManager.showFilter"), this.initShowFilter);
        this.objectId = Long.parseLong(site.getSecondaryId());
        Messages.get();
        this.setPartName(String.format(Messages.AgentFileManager_PartTitle, this.session.getObjectName(this.objectId)));
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void createPartControl(Composite parent) {
        String[] columnNames;
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AgentFileManager.this.onFilterModify();
            }
        });
        String os = ((Node)this.session.findObjectById(this.objectId)).getSystemDescription();
        if (os.contains("Windows")) {
            String[] stringArray = new String[5];
            Messages.get();
            stringArray[0] = Messages.AgentFileManager_ColName;
            Messages.get();
            stringArray[1] = Messages.AgentFileManager_ColType;
            Messages.get();
            stringArray[2] = Messages.AgentFileManager_ColSize;
            Messages.get();
            stringArray[3] = Messages.AgentFileManager_ColDate;
            Messages.get();
            stringArray[4] = Messages.AgentFileManager_ColOwner;
            columnNames = stringArray;
            int[] columnWidths = new int[]{300, 120, 150, 150, 150};
            this.viewer = new SortableTreeViewer(this.content, columnNames, columnWidths, 0, 128, -1);
        } else {
            String[] stringArray = new String[7];
            Messages.get();
            stringArray[0] = Messages.AgentFileManager_ColName;
            Messages.get();
            stringArray[1] = Messages.AgentFileManager_ColType;
            Messages.get();
            stringArray[2] = Messages.AgentFileManager_ColSize;
            Messages.get();
            stringArray[3] = Messages.AgentFileManager_ColDate;
            Messages.get();
            stringArray[4] = Messages.AgentFileManager_ColOwner;
            Messages.get();
            stringArray[5] = Messages.AgentFileManager_ColGroup;
            Messages.get();
            stringArray[6] = Messages.AgentFileManager_ColAccessRights;
            columnNames = stringArray;
            int[] columnWidths = new int[]{300, 120, 150, 150, 150, 150, 200};
            this.viewer = new SortableTreeViewer(this.content, columnNames, columnWidths, 0, 128, -1);
        }
        WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ViewAgentFilesProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AgentFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new AgentFileComparator());
        this.filter = new AgentFileFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    AgentFileManager.this.actionDelete.setEnabled(selection.size() > 0);
                    AgentFileManager.this.actionCalculateFolderSize.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTreeViewerSettings((SortableTreeViewer)AgentFileManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)AgentFileManager.TABLE_CONFIG_PREFIX);
            }
        });
        this.enableDragSupport();
        this.enableDropSupport();
        this.enableInPlaceRename();
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTree().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        this.filterText.setCloseAction(this.actionShowFilter);
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refreshFileList();
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("AgentFileManager.showFilter", this.initShowFilter);
        super.dispose();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.filemanager.context.FileManager");
        }
    }

    public void enableDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(3, transfers, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(AgentFileManager.this.viewer.getSelection());
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }
        });
    }

    public void enableDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(3, transfers, (DropTargetListener)new AgentFileDropAdapter((Viewer)this.viewer));
    }

    private void enableInPlaceRename() {
        TreeViewerEditor.create((TreeViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 4;
            }
        }, (int)1);
        this.viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.viewer.getTree())});
        this.viewer.setColumnProperties(new String[]{"name"});
        this.viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if (property.equals("name") && element instanceof AgentFile) {
                    AgentFileManager.this.doRename((AgentFile)element, value.toString());
                }
            }

            public Object getValue(Object element, String property) {
                if (property.equals("name") && element instanceof AgentFile) {
                    return ((AgentFile)element).getName();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return property.equals("name");
            }
        });
    }

    private void doRename(final AgentFile agentFile, final String newName) {
        new ConsoleJob("Rename file", (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AgentFileManager_RenameError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final NestedVerifyOverwrite verify = new NestedVerifyOverwrite(AgentFileManager.this, agentFile.getType(), newName, true, true, false){

                    @Override
                    public void executeAction() throws NXCException, IOException {
                        AgentFileManager.this.session.renameAgentFile(AgentFileManager.this.objectId, agentFile.getFullName(), String.valueOf(agentFile.getParent().getFullName()) + "/" + newName, false);
                    }

                    @Override
                    public void executeSameFunctionWithOverwrite() throws IOException, NXCException {
                        AgentFileManager.this.session.renameAgentFile(AgentFileManager.this.objectId, agentFile.getFullName(), String.valueOf(agentFile.getParent().getFullName()) + "/" + newName, true);
                    }
                };
                verify.run(AgentFileManager.this.viewer.getControl().getDisplay());
                if (verify.isOkPressed()) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (verify.isOkPressed()) {
                                AgentFileManager.this.refreshFileOrDirectory();
                            }
                            agentFile.setName(newName);
                            AgentFileManager.this.viewer.refresh((Object)agentFile, true);
                        }
                    });
                }
            }
        }.start();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionRefreshDirectory = new Action(Messages.AgentFileManager_RefreshFolder, SharedIcons.REFRESH){

            public void run() {
                AgentFileManager.this.refreshFileOrDirectory();
            }
        };
        this.actionRefreshDirectory.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.refreshFolder");
        handlerService.activateHandler(this.actionRefreshDirectory.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionRefreshDirectory));
        this.actionRefreshAll = new RefreshAction((IViewPart)this){

            public void run() {
                AgentFileManager.this.refreshFileList();
            }
        };
        Messages.get();
        this.actionUploadFile = new Action(Messages.AgentFileManager_UploadFile){

            public void run() {
                AgentFileManager.this.uploadFile(false);
            }
        };
        this.actionUploadFile.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.uploadFile");
        handlerService.activateHandler(this.actionUploadFile.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionUploadFile));
        Messages.get();
        this.actionUploadFolder = new Action(Messages.AgentFileManager_UploadFolder){

            public void run() {
                AgentFileManager.this.uploadFolder();
            }
        };
        Messages.get();
        this.actionDelete = new Action(Messages.AgentFileManager_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                AgentFileManager.this.deleteFile();
            }
        };
        this.actionDelete.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.delete");
        handlerService.activateHandler(this.actionDelete.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionDelete));
        Messages.get();
        this.actionRename = new Action(Messages.AgentFileManager_Rename){

            public void run() {
                AgentFileManager.this.renameFile();
            }
        };
        this.actionRename.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.rename");
        handlerService.activateHandler(this.actionRename.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionRename));
        Messages.get();
        this.actionShowFilter = new Action(Messages.ViewServerFile_ShowFilterAction, 2){

            public void run() {
                AgentFileManager.this.enableFilter(!AgentFileManager.this.initShowFilter);
                AgentFileManager.this.actionShowFilter.setChecked(AgentFileManager.this.initShowFilter);
            }
        };
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.showFilter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        Messages.get();
        this.actionDownloadFile = new Action(Messages.AgentFileManager_Download){

            public void run() {
                AgentFileManager.this.startDownload();
            }
        };
        this.actionDownloadFile.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.download");
        handlerService.activateHandler(this.actionDownloadFile.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionDownloadFile));
        Messages.get();
        this.actionTailFile = new Action(Messages.AgentFileManager_FollowChanges){

            public void run() {
                AgentFileManager.this.tailFile(true, 1024);
            }
        };
        Messages.get();
        this.actionShowFile = new Action(Messages.AgentFileManager_Show){

            public void run() {
                AgentFileManager.this.tailFile(false, 0);
            }
        };
        Messages.get();
        this.actionCreateDirectory = new Action(Messages.AgentFileManager_CreateFolder){

            public void run() {
                AgentFileManager.this.createFolder();
            }
        };
        this.actionCreateDirectory.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.newFolder");
        handlerService.activateHandler(this.actionCreateDirectory.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCreateDirectory));
        this.actionCalculateFolderSize = new Action("Calculate folder &size"){

            public void run() {
                AgentFileManager.this.calculateFolderSize();
            }
        };
        this.actionCalculateFolderSize.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.calculateFolderSize");
        handlerService.activateHandler(this.actionCalculateFolderSize.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCalculateFolderSize));
        this.actionCopyFileName = new Action("Copy file &name"){

            public void run() {
                AgentFileManager.this.copyFileName();
            }
        };
        this.actionCopyFileName.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.copyFileName");
        handlerService.activateHandler(this.actionCopyFileName.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopyFileName));
        this.actionCopyFilePath = new Action("Copy file &path"){

            public void run() {
                AgentFileManager.this.copyFilePath();
            }
        };
        this.actionCopyFilePath.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.copyFilePath");
        handlerService.activateHandler(this.actionCopyFilePath.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopyFilePath));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefreshAll);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefreshAll);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AgentFileManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection.size() == 1) {
            if (((AgentFile)selection.getFirstElement()).isDirectory()) {
                mgr.add((IAction)this.actionUploadFile);
                mgr.add((IAction)this.actionUploadFolder);
            } else {
                mgr.add((IAction)this.actionTailFile);
                mgr.add((IAction)this.actionShowFile);
            }
        }
        mgr.add((IAction)this.actionDownloadFile);
        if (this.isFolderOnlySelection(selection)) {
            mgr.add((IAction)this.actionCalculateFolderSize);
        }
        mgr.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            if (((AgentFile)selection.getFirstElement()).isDirectory()) {
                mgr.add((IAction)this.actionCreateDirectory);
            }
            mgr.add((IAction)this.actionRename);
        }
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            mgr.add((IAction)this.actionCopyFileName);
            mgr.add((IAction)this.actionCopyFilePath);
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        if (selection.size() == 1 && ((AgentFile)selection.getFirstElement()).isDirectory()) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.actionRefreshDirectory);
        }
    }

    private boolean isFolderOnlySelection(IStructuredSelection selection) {
        for (Object o : selection.toList()) {
            if (((AgentFile)o).isDirectory()) continue;
            return false;
        }
        return true;
    }

    private void refreshFileList() {
        Messages.get();
        new ConsoleJob(Messages.SelectServerFileDialog_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List files = AgentFileManager.this.session.listAgentFiles(null, "/", AgentFileManager.this.objectId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AgentFileManager.this.viewer.setInput((Object)files);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectServerFileDialog_JobError;
            }
        }.start();
    }

    private void refreshFileOrDirectory() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final Object[] objects = selection.toArray();
        new ConsoleJob("Reading remote directory", null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    if (!((AgentFile)objects[i]).isDirectory()) {
                        objects[i] = ((AgentFile)objects[i]).getParent();
                    }
                    final AgentFile sf = (AgentFile)objects[i];
                    sf.setChildren(AgentFileManager.this.session.listAgentFiles(sf, sf.getFullName(), AgentFileManager.this.objectId));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentFileManager.this.viewer.refresh((Object)sf);
                        }
                    });
                    ++i;
                }
            }

            protected String getErrorMessage() {
                return "Cannot read remote directory";
            }
        }.start();
    }

    private void uploadFile(final boolean overvrite) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        final AgentFile upladFolder = ((AgentFile)objects[0]).isDirectory() ? (AgentFile)objects[0] : ((AgentFile)objects[0]).getParent();
        final StartClientToServerFileUploadDialog dlg = new StartClientToServerFileUploadDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.AgentFileManager_UploadFileJobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

                protected void runInternal(final IProgressMonitor monitor) throws Exception {
                    List<File> fileList = dlg.getLocalFiles();
                    int i = 0;
                    while (i < fileList.size()) {
                        final File localFile = fileList.get(i);
                        String remoteFile = fileList.get(i).getName();
                        if (fileList.size() == 1) {
                            remoteFile = dlg.getRemoteFileName();
                        }
                        final String rFileName = remoteFile;
                        new NestedVerifyOverwrite(AgentFileManager.this, localFile.isDirectory() ? 2 : 1, localFile.getName(), true, true, false){

                            @Override
                            public void executeAction() throws NXCException, IOException {
                                session.uploadLocalFileToAgent(AgentFileManager.this.objectId, localFile, String.valueOf(upladFolder.getFullName()) + "/" + rFileName, overvrite, new ProgressListener(){
                                    private long prevWorkDone = 0L;

                                    public void setTotalWorkAmount(long workTotal) {
                                        Messages.get();
                                        monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + localFile.getAbsolutePath(), (int)workTotal);
                                    }

                                    public void markProgress(long workDone) {
                                        monitor.worked((int)(workDone - this.prevWorkDone));
                                        this.prevWorkDone = workDone;
                                    }
                                });
                                monitor.done();
                            }

                            @Override
                            public void executeSameFunctionWithOverwrite() throws IOException, NXCException {
                                session.uploadLocalFileToAgent(AgentFileManager.this.objectId, localFile, String.valueOf(upladFolder.getFullName()) + "/" + rFileName, true, new ProgressListener(){
                                    private long prevWorkDone = 0L;

                                    public void setTotalWorkAmount(long workTotal) {
                                        Messages.get();
                                        monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + localFile.getAbsolutePath(), (int)workTotal);
                                    }

                                    public void markProgress(long workDone) {
                                        monitor.worked((int)(workDone - this.prevWorkDone));
                                        this.prevWorkDone = workDone;
                                    }
                                });
                                monitor.done();
                            }
                        }.run(AgentFileManager.this.viewer.getControl().getDisplay());
                        ++i;
                    }
                    upladFolder.setChildren(session.listAgentFiles(upladFolder, upladFolder.getFullName(), AgentFileManager.this.objectId));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentFileManager.this.viewer.refresh((Object)upladFolder, true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot upload file to remote agent";
                }
            }.start();
        }
    }

    private void uploadFolder() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        AgentFile upladFolder = ((AgentFile)objects[0]).isDirectory() ? (AgentFile)objects[0] : ((AgentFile)objects[0]).getParent();
        StartClientToAgentFolderUploadDialog dlg = new StartClientToAgentFolderUploadDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            Messages.get();
            UploadConsoleJob job = new UploadConsoleJob(Messages.AgentFileManager_UploadFolderJobTitle, null, "org.netxms.ui.eclipse.filemanager", null, dlg.getLocalFile(), upladFolder, dlg.getRemoteFileName());
            job.start();
        }
    }

    private void deleteFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.ViewServerFile_DeleteConfirmation, (String)Messages.ViewServerFile_DeletAck)) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.ViewServerFile_DeletFileFromServerJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ViewServerFile_ErrorDeleteFileJob;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    final AgentFile sf = (AgentFile)objects[i];
                    AgentFileManager.this.session.deleteAgentFile(AgentFileManager.this.objectId, sf.getFullName());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            sf.getParent().removeChield(sf);
                            AgentFileManager.this.viewer.refresh((Object)sf.getParent());
                        }
                    });
                    ++i;
                }
            }
        }.start();
    }

    private void tailFile(final boolean followChanges, final int offset) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        if (((AgentFile)objects[0]).isDirectory()) {
            return;
        }
        final AgentFile sf = (AgentFile)objects[0];
        Messages.get();
        ConsoleJobCallingServerJob job = new ConsoleJobCallingServerJob(Messages.AgentFileManager_DownloadJobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.AgentFileManager_DownloadJobError, sf.getFullName(), AgentFileManager.this.objectId);
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final AgentFileData file = AgentFileManager.this.session.downloadFileFromAgent(AgentFileManager.this.objectId, sf.getFullName(), (long)offset, followChanges, null, (ServerJobIdUpdater)this);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String secondaryId = String.valueOf(Long.toString(AgentFileManager.this.objectId)) + "&" + URLEncoder.encode(sf.getName(), "UTF-8");
                            AgentFileViewer.createView(secondaryId, AgentFileManager.this.objectId, file, followChanges);
                        }
                        catch (Exception e) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            Shell shell = window.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.AgentFileManager_Error, (String)String.format(Messages.AgentFileManager_OpenViewError, e.getLocalizedMessage()));
                            Activator.logError("Exception in AgentFileManager.tailFile", e);
                        }
                    }
                });
            }
        };
        job.start();
    }

    private void startDownload() {
        String target;
        DirectoryDialog dlg;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        AgentFile sf = (AgentFile)selection.getFirstElement();
        if (!sf.isDirectory() && selection.size() == 1) {
            dlg = new FileDialog(this.getSite().getShell(), 8192);
            Messages.get();
            dlg.setText(Messages.AgentFileManager_StartDownloadDialogTitle);
            String[] filterExtensions = new String[]{"*.*"};
            dlg.setFilterExtensions(filterExtensions);
            String[] stringArray = new String[1];
            Messages.get();
            stringArray[0] = Messages.AgentFileManager_AllFiles;
            String[] filterNames = stringArray;
            dlg.setFilterNames(filterNames);
            dlg.setFileName(sf.getName());
            dlg.setOverwrite(true);
            target = dlg.open();
        } else {
            dlg = new DirectoryDialog(this.getSite().getShell());
            target = dlg.open();
        }
        if (target == null) {
            return;
        }
        final ArrayList<AgentFile> files = new ArrayList<AgentFile>(selection.size());
        for (Object o : selection.toList()) {
            files.add((AgentFile)o);
        }
        ConsoleJobCallingServerJob job = new ConsoleJobCallingServerJob("Download from agent", null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (files.size() == 1) {
                    AgentFile f = (AgentFile)files.get(0);
                    if (f.isDirectory()) {
                        long dirSize = -1L;
                        try {
                            dirSize = AgentFileManager.this.session.getAgentFileInfo(f).getSize();
                        }
                        catch (Exception exception) {}
                        monitor.beginTask(String.format("Downloading directory %s", f.getName()), dirSize >= 0L ? (int)dirSize : -1);
                        AgentFileManager.this.downloadDir(f, String.valueOf(target) + "/" + f.getName(), monitor, this);
                        monitor.done();
                    } else {
                        AgentFileManager.this.downloadFile(f, target, monitor, false, this);
                    }
                } else {
                    long total = 0L;
                    for (AgentFile f : files) {
                        if (this.isCanceled()) break;
                        if (f.isDirectory() && f.getSize() < 0L) {
                            try {
                                total += AgentFileManager.this.session.getAgentFileInfo(f).getSize();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        total += f.getSize();
                    }
                    monitor.beginTask("Downloading files", (int)total);
                    for (AgentFile f : files) {
                        if (this.isCanceled()) break;
                        if (f.isDirectory()) {
                            AgentFileManager.this.downloadDir(f, String.valueOf(target) + "/" + f.getName(), monitor, this);
                            continue;
                        }
                        AgentFileManager.this.downloadFile(f, String.valueOf(target) + "/" + f.getName(), monitor, true, this);
                    }
                    monitor.done();
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AgentFileManager_DirectoryReadError;
            }
        };
        job.start();
    }

    private void downloadDir(AgentFile sf, String localFileName, IProgressMonitor monitor, ConsoleJobCallingServerJob job) throws NXCException, IOException {
        File dir = new File(localFileName);
        dir.mkdir();
        List files = sf.getChildren();
        if (files == null) {
            files = this.session.listAgentFiles(sf, sf.getFullName(), sf.getNodeId());
            sf.setChildren(files);
        }
        for (AgentFile f : files) {
            if (job.isCanceled()) break;
            if (f.isDirectory()) {
                this.downloadDir(f, String.valueOf(localFileName) + "/" + f.getName(), monitor, job);
                continue;
            }
            this.downloadFile(f, String.valueOf(localFileName) + "/" + f.getName(), monitor, true, job);
        }
        dir.setLastModified(sf.getModifyicationTime().getTime());
    }

    private void downloadFile(final AgentFile sf, String localName, final IProgressMonitor monitor, final boolean subTask, ConsoleJobCallingServerJob job) throws IOException, NXCException {
        AgentFileData file;
        if (subTask) {
            monitor.subTask(String.format("Downloading file %s", sf.getFullName()));
        }
        if ((file = this.session.downloadFileFromAgent(this.objectId, sf.getFullName(), 0L, false, new ProgressListener(){

            public void setTotalWorkAmount(long workTotal) {
                if (!subTask) {
                    monitor.beginTask(String.format("Downloading file %s", sf.getFullName()), (int)workTotal);
                }
            }

            public void markProgress(long workDone) {
                monitor.worked((int)workDone);
            }
        }, (ServerJobIdUpdater)job)).getFile() != null) {
            int len;
            File outputFile = new File(localName);
            outputFile.createNewFile();
            FileInputStream in = new FileInputStream(file.getFile());
            FileOutputStream out = new FileOutputStream(outputFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            outputFile.setLastModified(sf.getModifyicationTime().getTime());
        }
    }

    private void renameFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        this.viewer.editElement(selection.getFirstElement(), 0);
    }

    private void moveFile(final AgentFile target, final AgentFile object) {
        Messages.get();
        new ConsoleJob(Messages.AgentFileManager_MoveFile, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AgentFileManager_MoveError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NestedVerifyOverwrite verify = new NestedVerifyOverwrite(AgentFileManager.this, object.getType(), object.getName(), true, true, false){

                    @Override
                    public void executeAction() throws NXCException, IOException {
                        AgentFileManager.this.session.renameAgentFile(AgentFileManager.this.objectId, object.getFullName(), String.valueOf(target.getFullName()) + "/" + object.getName(), false);
                    }

                    @Override
                    public void executeSameFunctionWithOverwrite() throws IOException, NXCException {
                        AgentFileManager.this.session.renameAgentFile(AgentFileManager.this.objectId, object.getFullName(), String.valueOf(target.getFullName()) + "/" + object.getName(), true);
                    }
                };
                verify.run(AgentFileManager.this.viewer.getControl().getDisplay());
                if (verify.isOkPressed()) {
                    target.setChildren(AgentFileManager.this.session.listAgentFiles(target, target.getFullName(), AgentFileManager.this.objectId));
                    object.getParent().setChildren(AgentFileManager.this.session.listAgentFiles(object.getParent(), object.getParent().getFullName(), AgentFileManager.this.objectId));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentFileManager.this.viewer.refresh((Object)object.getParent(), true);
                            object.setParent(target);
                            AgentFileManager.this.viewer.refresh((Object)object.getParent(), true);
                        }
                    });
                }
            }
        }.start();
    }

    private void copyFile(final AgentFile target, final AgentFile object) {
        new ConsoleJob("Copying file", (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                return "Cannot copy file";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NestedVerifyOverwrite verify = new NestedVerifyOverwrite(AgentFileManager.this, object.getType(), object.getName(), true, true, false){

                    @Override
                    public void executeAction() throws NXCException, IOException {
                        AgentFileManager.this.session.copyAgentFile(AgentFileManager.this.objectId, object.getFullName(), String.valueOf(target.getFullName()) + "/" + object.getName(), false);
                    }

                    @Override
                    public void executeSameFunctionWithOverwrite() throws IOException, NXCException {
                        AgentFileManager.this.session.copyAgentFile(AgentFileManager.this.objectId, object.getFullName(), String.valueOf(target.getFullName()) + "/" + object.getName(), true);
                    }
                };
                verify.run(AgentFileManager.this.viewer.getControl().getDisplay());
                if (verify.isOkPressed()) {
                    target.setChildren(AgentFileManager.this.session.listAgentFiles(target, target.getFullName(), AgentFileManager.this.objectId));
                    object.getParent().setChildren(AgentFileManager.this.session.listAgentFiles(object.getParent(), object.getParent().getFullName(), AgentFileManager.this.objectId));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentFileManager.this.viewer.refresh((Object)object.getParent(), true);
                            object.setParent(target);
                            AgentFileManager.this.viewer.refresh((Object)target, true);
                        }
                    });
                }
            }
        }.start();
    }

    private void createFolder() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        final AgentFile parentFolder = ((AgentFile)objects[0]).isDirectory() ? (AgentFile)objects[0] : ((AgentFile)objects[0]).getParent();
        CreateFolderDialog dlg = new CreateFolderDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        final String newFolder = dlg.getNewName();
        Messages.get();
        new ConsoleJob(Messages.AgentFileManager_CreatingFolder, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AgentFileManager_FolderCreationError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NestedVerifyOverwrite verify = new NestedVerifyOverwrite(AgentFileManager.this, 2, newFolder, true, true, false){

                    @Override
                    public void executeAction() throws NXCException, IOException {
                        AgentFileManager.this.session.createFolderOnAgent(AgentFileManager.this.objectId, String.valueOf(parentFolder.getFullName()) + "/" + newFolder);
                    }

                    @Override
                    public void executeSameFunctionWithOverwrite() throws IOException, NXCException {
                    }
                };
                verify.run(AgentFileManager.this.viewer.getControl().getDisplay());
                parentFolder.setChildren(AgentFileManager.this.session.listAgentFiles(parentFolder, parentFolder.getFullName(), AgentFileManager.this.objectId));
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AgentFileManager.this.viewer.refresh((Object)parentFolder, true);
                    }
                });
            }
        }.start();
    }

    private void calculateFolderSize() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final ArrayList<AgentFile> files = new ArrayList<AgentFile>(selection.size());
        for (Object o : selection.toList()) {
            files.add((AgentFile)o);
        }
        new ConsoleJob("Calculate folder size", (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (AgentFile f : files) {
                    f.setFileInfo(AgentFileManager.this.session.getAgentFileInfo(f));
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AgentFileManager.this.viewer.update(files.toArray(), null);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot calculate folder size";
            }
        }.start();
    }

    private void copyFileName() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        WidgetHelper.copyToClipboard((String)((AgentFile)selection.getFirstElement()).getName());
    }

    private void copyFilePath() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        WidgetHelper.copyToClipboard((String)((AgentFile)selection.getFirstElement()).getFilePath());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTree().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    public class AgentFileDropAdapter
    extends ViewerDropAdapter {
        int operation;

        protected AgentFileDropAdapter(Viewer viewer) {
            super(viewer);
            this.operation = 0;
        }

        public boolean performDrop(Object data) {
            IStructuredSelection selection = (IStructuredSelection)data;
            List movableSelection = selection.toList();
            int i = 0;
            while (i < movableSelection.size()) {
                AgentFile movableObject = (AgentFile)movableSelection.get(i);
                if (this.operation == 1) {
                    AgentFileManager.this.copyFile((AgentFile)this.getCurrentTarget(), movableObject);
                } else {
                    AgentFileManager.this.moveFile((AgentFile)this.getCurrentTarget(), movableObject);
                }
                ++i;
            }
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            this.operation = operation;
            if (target == null || !LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                return false;
            }
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            if (selection.isEmpty()) {
                return false;
            }
            for (Object object : selection.toList()) {
                if (object instanceof AgentFile) continue;
                return false;
            }
            if (!(target instanceof AgentFile)) {
                return false;
            }
            return ((AgentFile)target).isDirectory();
        }
    }

    abstract class NestedVerifyOverwrite {
        private boolean okPresseed;
        private int type;
        private String name;
        private boolean askFolderOverwrite;
        private boolean askFileOverwrite;
        private boolean overwrite;

        public NestedVerifyOverwrite(int fileType, String fileName, boolean askFolderOverwrite, boolean askFileOverwrite, boolean overwrite) {
            this.type = fileType;
            this.name = fileName;
            this.askFolderOverwrite = askFolderOverwrite;
            this.askFileOverwrite = askFileOverwrite;
            this.overwrite = overwrite;
            this.okPresseed = true;
        }

        public boolean askFolderOverwrite() {
            return this.askFolderOverwrite;
        }

        public boolean askFileOverwrite() {
            return this.askFileOverwrite;
        }

        public void run(Display disp) throws IOException, NXCException {
            try {
                this.executeAction();
            }
            catch (NXCException e) {
                if (e.getErrorCode() == 127 || this.type == 2) {
                    if (this.askFolderOverwrite) {
                        disp.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DialogData data = MessageDialogHelper.openOneButtonWarningWithCheckbox((Shell)AgentFileManager.this.getSite().getShell(), (String)String.format("%s already exist", e.getErrorCode() == 127 ? "Folder" : "File"), (String)"Do not show again for this upload", (String)String.format("%s %s already exist", e.getErrorCode() == 127 ? "Folder" : "File", NestedVerifyOverwrite.this.name));
                                NestedVerifyOverwrite.this.askFolderOverwrite = !data.getSaveSelection();
                                NestedVerifyOverwrite.this.okPresseed = false;
                            }
                        });
                    }
                }
                if (e.getErrorCode() == 126 || e.getErrorCode() == 127) {
                    if (this.askFileOverwrite) {
                        disp.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DialogData data = MessageDialogHelper.openWarningWithCheckbox((Shell)AgentFileManager.this.getSite().getShell(), (String)String.format("%s overwrite confirmation", NestedVerifyOverwrite.this.type == 2 ? "Folder" : "File"), (String)"Save chose for current upload files", (String)String.format("%s with %s name already exists. Are you sure you want to overwrite it?", e.getErrorCode() == 127 ? "Folder" : "File", NestedVerifyOverwrite.this.name));
                                NestedVerifyOverwrite.this.askFileOverwrite = !data.getSaveSelection();
                                NestedVerifyOverwrite.this.okPresseed = data.isOkPressed();
                            }
                        });
                        if (this.okPresseed) {
                            this.executeSameFunctionWithOverwrite();
                        }
                    } else if (this.overwrite) {
                        this.executeSameFunctionWithOverwrite();
                    }
                }
                throw e;
            }
        }

        public boolean isOkPressed() {
            return this.okPresseed;
        }

        public abstract void executeAction() throws NXCException, IOException;

        public abstract void executeSameFunctionWithOverwrite() throws NXCException, IOException;
    }

    class UploadConsoleJob
    extends ConsoleJob {
        private boolean askFolderOverwrite;
        private boolean askFileOverwrite;
        private boolean overwrite;
        private File folder;
        private AgentFile uploadFolder;
        private String remoteFileName;

        public UploadConsoleJob(String name, IWorkbenchPart wbPart, String pluginId, Object jobFamily, File folder, AgentFile uploadFolder, String remoteFileName) {
            super(name, wbPart, pluginId, jobFamily);
            this.askFolderOverwrite = true;
            this.askFileOverwrite = true;
            this.overwrite = false;
            this.folder = folder;
            this.uploadFolder = uploadFolder;
            this.remoteFileName = remoteFileName;
        }

        protected void runInternal(IProgressMonitor monitor) throws Exception {
            NestedVerifyOverwrite verify = new NestedVerifyOverwrite(AgentFileManager.this, 2, this.folder.getName(), this.askFolderOverwrite, this.askFileOverwrite, this.overwrite){

                @Override
                public void executeAction() throws NXCException, IOException {
                    AgentFileManager.this.session.createFolderOnAgent(AgentFileManager.this.objectId, String.valueOf(UploadConsoleJob.this.uploadFolder.getFullName()) + "/" + UploadConsoleJob.this.remoteFileName);
                }

                @Override
                public void executeSameFunctionWithOverwrite() throws NXCException, IOException {
                }
            };
            verify.run(AgentFileManager.this.viewer.getControl().getDisplay());
            this.askFolderOverwrite = verify.askFolderOverwrite();
            this.uploadFilesInFolder(this.folder, String.valueOf(this.uploadFolder.getFullName()) + "/" + this.remoteFileName, monitor);
            this.uploadFolder.setChildren(AgentFileManager.this.session.listAgentFiles(this.uploadFolder, this.uploadFolder.getFullName(), AgentFileManager.this.objectId));
            this.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    AgentFileManager.this.viewer.refresh((Object)UploadConsoleJob.this.uploadFolder, true);
                }
            });
        }

        protected String getErrorMessage() {
            Messages.get();
            return Messages.UploadFileToServer_JobError;
        }

        public void uploadFilesInFolder(File folder, final String uploadFolder, final IProgressMonitor monitor) throws NXCException, IOException {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                NestedVerifyOverwrite verify;
                final File fileEntry = fileArray[n2];
                if (fileEntry.isDirectory()) {
                    verify = new NestedVerifyOverwrite(AgentFileManager.this, 2, fileEntry.getName(), this.askFolderOverwrite, this.askFileOverwrite, this.overwrite){

                        @Override
                        public void executeAction() throws NXCException, IOException {
                            AgentFileManager.this.session.createFolderOnAgent(AgentFileManager.this.objectId, String.valueOf(uploadFolder) + "/" + fileEntry.getName());
                        }

                        @Override
                        public void executeSameFunctionWithOverwrite() throws NXCException, IOException {
                        }
                    };
                    verify.run(AgentFileManager.this.viewer.getControl().getDisplay());
                    this.askFolderOverwrite = verify.askFolderOverwrite();
                    this.uploadFilesInFolder(fileEntry, String.valueOf(uploadFolder) + "/" + fileEntry.getName(), monitor);
                } else {
                    verify = new NestedVerifyOverwrite(AgentFileManager.this, 1, fileEntry.getName(), this.askFolderOverwrite, this.askFileOverwrite, this.overwrite){

                        @Override
                        public void executeAction() throws NXCException, IOException {
                            AgentFileManager.this.session.uploadLocalFileToAgent(AgentFileManager.this.objectId, fileEntry, String.valueOf(uploadFolder) + "/" + fileEntry.getName(), UploadConsoleJob.this.overwrite, new ProgressListener(){
                                private long prevWorkDone = 0L;

                                public void setTotalWorkAmount(long workTotal) {
                                    Messages.get();
                                    monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + fileEntry.getAbsolutePath(), (int)workTotal);
                                }

                                public void markProgress(long workDone) {
                                    monitor.worked((int)(workDone - this.prevWorkDone));
                                    this.prevWorkDone = workDone;
                                }
                            });
                            monitor.done();
                        }

                        @Override
                        public void executeSameFunctionWithOverwrite() throws NXCException, IOException {
                            AgentFileManager.this.session.uploadLocalFileToAgent(AgentFileManager.this.objectId, fileEntry, String.valueOf(uploadFolder) + "/" + fileEntry.getName(), true, new ProgressListener(){
                                private long prevWorkDone = 0L;

                                public void setTotalWorkAmount(long workTotal) {
                                    Messages.get();
                                    monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + fileEntry.getAbsolutePath(), (int)workTotal);
                                }

                                public void markProgress(long workDone) {
                                    monitor.worked((int)(workDone - this.prevWorkDone));
                                    this.prevWorkDone = workDone;
                                }
                            });
                            monitor.done();
                        }
                    };
                    verify.run(AgentFileManager.this.viewer.getControl().getDisplay());
                    this.askFileOverwrite = verify.askFileOverwrite();
                    if (!this.askFileOverwrite) {
                        this.overwrite = verify.isOkPressed();
                    }
                }
                ++n2;
            }
        }
    }
}

