/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.netxms.base.NXCommon;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.RackElement;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.widgets.ObjectPopupDialog;
import org.netxms.ui.eclipse.objectview.widgets.helpers.RackSelectionListener;
import org.netxms.ui.eclipse.tools.FontTools;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class RackWidget
extends Canvas
implements PaintListener,
DisposeListener,
ImageUpdateListener,
MouseListener,
MouseTrackListener {
    private static final double UNIT_WH_RATIO = 10.85;
    private static final int BORDER_WIDTH_RATIO = 15;
    private static final int FULL_UNIT_WIDTH = 482;
    private static final int FULL_UNIT_HEIGHT = 45;
    private static final int MARGIN_HEIGHT = 10;
    private static final int MARGIN_WIDTH = 10;
    private static final int UNIT_NUMBER_WIDTH = 30;
    private static final int TITLE_HEIGHT = 20;
    private static final String[] FONT_NAMES = new String[]{"Segoe UI", "Liberation Sans", "DejaVu Sans", "Verdana", "Arial"};
    private static final String[] VIEW_LABELS = new String[]{"Front", "Back"};
    private Rack rack;
    private Font[] labelFonts;
    private Font[] titleFonts;
    private Image imageDefaultTop;
    private Image imageDefaultMiddle;
    private Image imageDefaultBottom;
    private Image imageDefaultRear;
    private Image imagePatchPanel;
    private Image imageFillerPanel;
    private Image imageOrganiserPanel;
    private List<ObjectImage> objects = new ArrayList<ObjectImage>();
    private AbstractObject selectedObject = null;
    private Set<RackSelectionListener> selectionListeners = new HashSet<RackSelectionListener>(0);
    private AbstractObject tooltipObject = null;
    private ObjectPopupDialog tooltipDialog = null;
    private RackOrientation view;

    public RackWidget(Composite parent, int style, Rack rack, RackOrientation view) {
        super(parent, style | 0x20000000);
        this.rack = rack;
        this.view = view == RackOrientation.FILL ? RackOrientation.FRONT : view;
        this.setBackground(SharedColors.getColor((String)"Rack.Background", (Display)this.getDisplay()));
        this.labelFonts = FontTools.getFonts((String[])FONT_NAMES, (int)6, (int)0, (int)16);
        this.titleFonts = FontTools.getFonts((String[])FONT_NAMES, (int)6, (int)1, (int)16);
        this.imageDefaultTop = Activator.getImageDescriptor("icons/rack-default-top.png").createImage();
        this.imageDefaultMiddle = Activator.getImageDescriptor("icons/rack-default-middle.png").createImage();
        this.imageDefaultBottom = Activator.getImageDescriptor("icons/rack-default-bottom.png").createImage();
        this.imageDefaultRear = Activator.getImageDescriptor("icons/rack-default-rear.png").createImage();
        this.imagePatchPanel = Activator.getImageDescriptor("icons/rack-patch-panel.png").createImage();
        this.imageOrganiserPanel = Activator.getImageDescriptor("icons/rack-filler-panel.png").createImage();
        this.imageFillerPanel = Activator.getImageDescriptor("icons/rack-filler-panel.png").createImage();
        this.addPaintListener(this);
        this.addMouseListener(this);
        WidgetHelper.attachMouseTrackListener((Composite)this, (MouseTrackListener)this);
        this.addDisposeListener(this);
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
    }

    public AbstractObject getCurrentObject() {
        return this.selectedObject;
    }

    public void paintControl(PaintEvent e) {
        double dy;
        GC gc = e.gc;
        gc.setAntialias(1);
        gc.setInterpolation(2);
        Rectangle rect = this.getClientArea();
        rect.x += 40;
        rect.y += 35;
        rect.height -= 45;
        double unitHeight = (double)rect.height / (double)this.rack.getHeight();
        int unitWidth = (int)(unitHeight * 10.85);
        int borderWidth = unitWidth / 15;
        if (borderWidth < 3) {
            borderWidth = 3;
        }
        rect.height -= borderWidth;
        unitHeight = (double)(rect.height - (borderWidth + 1) / 2 * 2) / (double)this.rack.getHeight();
        unitWidth = (int)(unitHeight * 10.85);
        rect.width = unitWidth + borderWidth * 2;
        gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.titleFonts, (String)VIEW_LABELS[0], (int)rect.width, (int)20));
        Point titleSize = gc.textExtent(VIEW_LABELS[this.view.getValue() - 1]);
        gc.drawText(VIEW_LABELS[this.view.getValue() - 1], rect.width / 2 - titleSize.x / 2 + 30 + 10, rect.y - 20 - 5);
        gc.setBackground(SharedColors.getColor((String)"Rack.EmptySpace", (Display)this.getDisplay()));
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setLineWidth(borderWidth);
        gc.setForeground(SharedColors.getColor((String)"Rack.Border", (Display)this.getDisplay()));
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setBackground(SharedColors.getColor((String)"Rack.Border", (Display)this.getDisplay()));
        gc.fillRectangle(rect.x + borderWidth * 2 - (borderWidth + 1) / 2, rect.y + rect.height, borderWidth * 2, (int)((double)borderWidth * 1.5));
        gc.fillRectangle(rect.x + rect.width - borderWidth * 3 - (borderWidth + 1) / 2, rect.y + rect.height, borderWidth * 2, (int)((double)borderWidth * 1.5));
        int[] unitBaselines = new int[this.rack.getHeight() + 1];
        gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.labelFonts, (String)"00", (int)30, (int)((int)unitHeight - 2)));
        gc.setForeground(SharedColors.getColor((String)"Rack.Text", (Display)this.getDisplay()));
        gc.setBackground(SharedColors.getColor((String)"Rack.Background", (Display)this.getDisplay()));
        gc.setLineWidth(1);
        double d = dy = this.rack.isTopBottomNumbering() ? (double)rect.y + unitHeight + (double)((borderWidth + 1) / 2) : (double)(rect.y + rect.height - (borderWidth + 1) / 2);
        if (this.rack.isTopBottomNumbering()) {
            unitBaselines[0] = (int)(dy - unitHeight);
        }
        int u = 1;
        while (u <= this.rack.getHeight()) {
            int y = (int)dy;
            gc.drawLine(10, y, 30, y);
            String label = Integer.toString(u);
            Point textExtent = gc.textExtent(label);
            gc.drawText(label, 30 - textExtent.x, y - (int)unitHeight / 2 - textExtent.y / 2);
            if (this.rack.isTopBottomNumbering()) {
                unitBaselines[u] = y;
                dy += unitHeight;
            } else {
                unitBaselines[u - 1] = y;
                dy -= unitHeight;
            }
            ++u;
        }
        if (!this.rack.isTopBottomNumbering()) {
            unitBaselines[this.rack.getHeight()] = (int)dy;
        }
        List attributes = this.rack.getPassiveElements().getElements();
        block6: for (PassiveRackElement c : attributes) {
            Image image;
            int topLine;
            int bottomLine;
            if (c.getPosition() < 1 || c.getPosition() > this.rack.getHeight() || c.getOrientation() != this.view && c.getOrientation() != RackOrientation.FILL) continue;
            if (this.rack.isTopBottomNumbering()) {
                bottomLine = unitBaselines[c.getPosition()];
                topLine = unitBaselines[c.getPosition() - 1];
            } else {
                bottomLine = unitBaselines[c.getPosition() - 1];
                topLine = unitBaselines[c.getPosition()];
            }
            Rectangle unitRect = new Rectangle(rect.x + (borderWidth + 1) / 2, topLine + 1, rect.width - borderWidth, bottomLine - topLine);
            if (unitRect.width <= 0 || unitRect.height <= 0) break;
            switch (c.getType()) {
                case FILLER_PANEL: {
                    image = this.imageFillerPanel;
                    break;
                }
                case PATCH_PANEL: {
                    image = this.imagePatchPanel;
                    break;
                }
                case ORGANISER: {
                    image = this.imageOrganiserPanel;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            Rectangle r = image.getBounds();
            gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
        }
        this.objects.clear();
        List units = this.rack.getUnits();
        for (RackElement n : units) {
            int i;
            int u2;
            Image imageBottom;
            Rectangle r;
            Image image;
            int topLine;
            int bottomLine;
            if (n.getRackPosition() < 1 || n.getRackPosition() > this.rack.getHeight() || this.rack.isTopBottomNumbering() && n.getRackPosition() + n.getRackHeight() > this.rack.getHeight() + 1 || !this.rack.isTopBottomNumbering() && n.getRackPosition() - n.getRackHeight() < 0 || n.getRackOrientation() != this.view && n.getRackOrientation() != RackOrientation.FILL) continue;
            if (this.rack.isTopBottomNumbering()) {
                bottomLine = unitBaselines[n.getRackPosition() + n.getRackHeight() - 1];
                topLine = unitBaselines[n.getRackPosition() - 1];
            } else {
                bottomLine = unitBaselines[n.getRackPosition() - n.getRackHeight()];
                topLine = unitBaselines[n.getRackPosition()];
            }
            Rectangle unitRect = new Rectangle(rect.x + (borderWidth + 1) / 2, topLine + 1, rect.width - borderWidth, bottomLine - topLine);
            if (unitRect.width <= 0 || unitRect.height <= 0) break;
            this.objects.add(new ObjectImage(n, unitRect));
            gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)n.getStatus()));
            gc.fillRectangle(unitRect.x - borderWidth + borderWidth / 4 + 1, unitRect.y + 1, borderWidth / 2 - 1, Math.min(borderWidth, (int)unitHeight - 2));
            if (n.getRearRackImage() != null && !n.getRearRackImage().equals(NXCommon.EMPTY_GUID) && this.view == RackOrientation.REAR) {
                image = ImageProvider.getInstance().getImage(n.getRearRackImage());
                r = image.getBounds();
                gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            if (n.getFrontRackImage() != null && !n.getFrontRackImage().equals(NXCommon.EMPTY_GUID) && this.view == RackOrientation.FRONT) {
                image = ImageProvider.getInstance().getImage(n.getFrontRackImage());
                r = image.getBounds();
                gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            Image imageTop = this.view == RackOrientation.REAR && n.getRackOrientation() == RackOrientation.FILL ? this.imageDefaultRear : this.imageDefaultTop;
            r = imageTop.getBounds();
            if (n.getRackHeight() == 1) {
                gc.drawImage(imageTop, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            Image imageMiddle = this.view == RackOrientation.REAR && n.getRackOrientation() == RackOrientation.FILL ? this.imageDefaultRear : this.imageDefaultMiddle;
            Image image2 = imageBottom = this.view == RackOrientation.REAR && n.getRackOrientation() == RackOrientation.FILL ? this.imageDefaultRear : this.imageDefaultBottom;
            if (this.rack.isTopBottomNumbering()) {
                unitRect.height = unitBaselines[n.getRackPosition()] - topLine;
                gc.drawImage(imageTop, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                r = imageMiddle.getBounds();
                u2 = n.getRackPosition() + 1;
                i = 1;
                while (i < n.getRackHeight() - 1) {
                    unitRect.y = unitBaselines[u2 - 1];
                    unitRect.height = unitBaselines[u2] - unitRect.y;
                    gc.drawImage(imageMiddle, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                    ++i;
                    ++u2;
                }
                r = imageBottom.getBounds();
                unitRect.y = unitBaselines[u2 - 1];
                unitRect.height = unitBaselines[u2] - unitRect.y;
                gc.drawImage(imageBottom, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            unitRect.height = unitBaselines[n.getRackPosition() - 1] - topLine;
            gc.drawImage(imageTop, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
            r = imageMiddle.getBounds();
            u2 = n.getRackPosition() - 1;
            i = 1;
            while (i < n.getRackHeight() - 1) {
                unitRect.y = unitBaselines[u2];
                unitRect.height = unitBaselines[u2 - 1] - unitRect.y;
                gc.drawImage(imageMiddle, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                ++i;
                --u2;
            }
            r = imageBottom.getBounds();
            unitRect.y = unitBaselines[u2];
            unitRect.height = unitBaselines[u2 - 1] - unitRect.y;
            gc.drawImage(imageBottom, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (hHint == -1 && wHint == -1) {
            return new Point(10, 10);
        }
        if (hHint == -1) {
            int borderWidth = 32;
            return new Point(532 + borderWidth * 2, this.rack.getHeight() * 45 + 20 + borderWidth * 2);
        }
        double unitHeight = (double)hHint / (double)this.rack.getHeight();
        int unitWidth = (int)(unitHeight * 10.85);
        int borderWidth = unitWidth / 15;
        if (borderWidth < 3) {
            borderWidth = 3;
        }
        unitWidth = (int)((double)(hHint - (borderWidth + 1) / 2 * 2 - 20) / (double)this.rack.getHeight() * 10.85);
        return new Point(unitWidth + 20 + 30 + borderWidth * 2, hHint);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.imageDefaultTop.dispose();
        this.imageDefaultMiddle.dispose();
        this.imageDefaultBottom.dispose();
        this.imageDefaultRear.dispose();
        this.imageFillerPanel.dispose();
        this.imagePatchPanel.dispose();
        this.imageOrganiserPanel.dispose();
        ImageProvider.getInstance().removeUpdateListener((ImageUpdateListener)this);
    }

    public void imageUpdated(UUID guid) {
        boolean found = false;
        List units = this.rack.getUnits();
        for (RackElement e : units) {
            if (!guid.equals(e.getFrontRackImage()) && !guid.equals(e.getRearRackImage())) continue;
            found = true;
            break;
        }
        if (found) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!RackWidget.this.isDisposed()) {
                        RackWidget.this.redraw();
                    }
                }
            });
        }
    }

    private AbstractObject getObjectAtPoint(Point p) {
        for (ObjectImage i : this.objects) {
            if (!i.contains(p)) continue;
            return (AbstractObject)i.getObject();
        }
        return null;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != this.tooltipDialog.getShell()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
        this.tooltipObject = null;
        this.setCurrentObject(this.getObjectAtPoint(new Point(e.x, e.y)));
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != this.tooltipDialog.getShell()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
        this.tooltipObject = null;
    }

    public void mouseHover(MouseEvent e) {
        AbstractObject object = this.getObjectAtPoint(new Point(e.x, e.y));
        if (object != null && (object != this.tooltipObject || this.tooltipDialog == null || this.tooltipDialog.getShell() == null || this.tooltipDialog.getShell().isDisposed())) {
            if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed()) {
                this.tooltipDialog.close();
            }
            this.tooltipObject = object;
            this.tooltipDialog = new ObjectPopupDialog(this.getShell(), object, this.toDisplay(e.x, e.y));
            this.tooltipDialog.open();
        } else if (object == null && this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
    }

    public void addSelectionListener(RackSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(RackSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void setCurrentObject(AbstractObject o) {
        this.selectedObject = o;
        for (RackSelectionListener l : this.selectionListeners) {
            l.objectSelected(this.selectedObject);
        }
    }

    private class ObjectImage {
        private RackElement object;
        private Rectangle rect;

        public ObjectImage(RackElement object, Rectangle rect) {
            this.object = object;
            this.rect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }

        public boolean contains(Point p) {
            return this.rect.contains(p);
        }

        public RackElement getObject() {
            return this.object;
        }
    }
}

