/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeViewer;

public class ObjectStatusIndicator
extends Canvas
implements PaintListener {
    private ObjectTreeViewer objectTree = null;
    private boolean showIcons = false;
    private boolean hideNormal = true;
    private boolean hideUnmanaged = true;
    private boolean hideUnknown = true;
    private boolean hideDisabled = true;
    private Action actionShowIcons;
    private Action actionHideNormal;
    private Action actionHideUnmanaged;
    private Action actionHideUnknown;
    private Action actionHideDisabled;

    public ObjectStatusIndicator(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addPaintListener(this);
        this.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)this.getDisplay()));
        final IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.showIcons = ps.getBoolean("ObjectStatusIndicator.showIcons");
        this.hideNormal = ps.getBoolean("ObjectStatusIndicator.hideNormal");
        this.hideUnmanaged = ps.getBoolean("ObjectStatusIndicator.hideUnmanaged");
        this.hideUnknown = ps.getBoolean("ObjectStatusIndicator.hideUnknown");
        this.hideDisabled = ps.getBoolean("ObjectStatusIndicator.hideDisabled");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ps.setValue("ObjectStatusIndicator.showIcons", ObjectStatusIndicator.this.showIcons);
                ps.setValue("ObjectStatusIndicator.hideNormal", ObjectStatusIndicator.this.hideNormal);
                ps.setValue("ObjectStatusIndicator.hideUnmanaged", ObjectStatusIndicator.this.hideUnmanaged);
                ps.setValue("ObjectStatusIndicator.hideUnknown", ObjectStatusIndicator.this.hideUnknown);
                ps.setValue("ObjectStatusIndicator.hideDisabled", ObjectStatusIndicator.this.hideDisabled);
            }
        });
        this.createActions();
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectStatusIndicator.this.fillContextMenu(mgr);
            }
        });
        this.setMenu(manager.createContextMenu((Control)this));
    }

    private void createActions() {
        Messages.get();
        this.actionShowIcons = new Action(Messages.ObjectStatusIndicator_ShowIcons, 2){

            public void run() {
                ObjectStatusIndicator.this.showIcons = ObjectStatusIndicator.this.actionShowIcons.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionShowIcons.setChecked(this.showIcons);
        Messages.get();
        this.actionHideDisabled = new Action(Messages.ObjectStatusIndicator_HideDisabled, 2){

            public void run() {
                ObjectStatusIndicator.this.hideDisabled = ObjectStatusIndicator.this.actionHideDisabled.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionHideDisabled.setChecked(this.hideDisabled);
        Messages.get();
        this.actionHideNormal = new Action(Messages.ObjectStatusIndicator_HideNormal, 2){

            public void run() {
                ObjectStatusIndicator.this.hideNormal = ObjectStatusIndicator.this.actionHideNormal.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionHideNormal.setChecked(this.hideNormal);
        Messages.get();
        this.actionHideUnknown = new Action(Messages.ObjectStatusIndicator_HideUnknown, 2){

            public void run() {
                ObjectStatusIndicator.this.hideUnknown = ObjectStatusIndicator.this.actionHideUnknown.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionHideUnknown.setChecked(this.hideUnknown);
        Messages.get();
        this.actionHideUnmanaged = new Action(Messages.ObjectStatusIndicator_HideUnmanaged, 2){

            public void run() {
                ObjectStatusIndicator.this.hideUnmanaged = ObjectStatusIndicator.this.actionHideUnmanaged.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionHideUnmanaged.setChecked(this.hideUnmanaged);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowIcons);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideNormal);
        manager.add((IAction)this.actionHideUnknown);
        manager.add((IAction)this.actionHideUnmanaged);
        manager.add((IAction)this.actionHideDisabled);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(21, 10);
    }

    public void paintControl(PaintEvent e) {
        if (this.objectTree == null) {
            return;
        }
        GC gc = e.gc;
        gc.setAntialias(1);
        int width = this.getClientArea().width;
        TreeItem item = this.objectTree.getTree().getTopItem();
        if (item != null) {
            int y = 0;
            int limit = this.objectTree.getTree().getClientArea().height;
            int height = this.objectTree.getTree().getItemHeight();
            ViewerRow row = this.objectTree.getTreeViewerRow(item);
            block0: while (row != null && y < limit) {
                AbstractObject object = (AbstractObject)row.getItem().getData();
                this.drawObject(gc, object, y, width, height);
                y += height;
                row = row.getNeighbor(2, false);
                if (row != null) continue;
                int i = 16;
                while (i < 192) {
                    item = this.objectTree.getTree().getItem(new Point(y, y + height / 2));
                    if (item != null) {
                        row = this.objectTree.getTreeViewerRow(item);
                        continue block0;
                    }
                    i += 16;
                }
            }
        }
        gc.setForeground(SharedColors.getColor((String)"Border", (Display)this.getDisplay()));
        gc.drawLine(width - 1, 0, width - 1, this.getClientArea().height);
    }

    private void drawObject(GC gc, AbstractObject object, int y, int width, int height) {
        ObjectStatus status = object.getStatus();
        if (status == ObjectStatus.NORMAL && this.hideNormal) {
            return;
        }
        if (status == ObjectStatus.UNMANAGED && this.hideUnmanaged) {
            return;
        }
        if (status == ObjectStatus.UNKNOWN && this.hideUnknown) {
            return;
        }
        if (status == ObjectStatus.DISABLED && this.hideDisabled) {
            return;
        }
        if (this.showIcons) {
            gc.drawImage(StatusDisplayInfo.getStatusImage((ObjectStatus)status), (width - 16) / 2, y + (height - 16) / 2);
        } else {
            gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)status));
            gc.setForeground(StatusDisplayInfo.getStatusColor((ObjectStatus)status));
            int size = Math.min(width - 8, height - 8);
            gc.setAlpha(127);
            gc.fillOval((width - size) / 2, y + (height - size) / 2, size, size);
            gc.setAlpha(255);
            gc.drawOval((width - size) / 2, y + (height - size) / 2, size, size);
        }
    }

    public void refresh(ObjectTreeViewer objectTree) {
        this.objectTree = objectTree;
        this.redraw();
    }
}

