/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.ui.eclipse.dashboard.widgets.DCISummaryTableColumnSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DCISummaryTableSortColumnSelectionDialog
extends Dialog {
    String sortingColumn = "";
    DCISummaryTableColumnSelector selector;
    DciSummaryTable sourceSummaryTable;
    Button descSorting;
    boolean isDescSorting;
    int summaryTableId;

    public DCISummaryTableSortColumnSelectionDialog(Shell parentShell, String sortingColumn, boolean descSorting, int summaryTableId) {
        super(parentShell);
        this.sortingColumn = sortingColumn;
        this.isDescSorting = descSorting;
        this.summaryTableId = summaryTableId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit sorting column");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get summary table configuration by id", null, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DCISummaryTableSortColumnSelectionDialog.this.sourceSummaryTable = session.getDciSummaryTable(DCISummaryTableSortColumnSelectionDialog.this.summaryTableId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DCISummaryTableSortColumnSelectionDialog.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Unable to get summary table configuration";
            }
        }.start();
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.selector = new DCISummaryTableColumnSelector(dialogArea, 0, 8, this.sortingColumn, null, this.sourceSummaryTable);
        this.selector.setLabel("Filter column name");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 520;
        this.selector.setLayoutData(gd);
        this.descSorting = new Button(dialogArea, 32);
        gd = new GridData();
        this.descSorting.setText("Use descending sorting");
        this.descSorting.setLayoutData((Object)gd);
        this.descSorting.setSelection(this.isDescSorting);
        return dialogArea;
    }

    private void refresh() {
        this.selector.setSummaryTbale(this.sourceSummaryTable);
    }

    protected void okPressed() {
        this.sortingColumn = String.valueOf(this.descSorting.getSelection() ? ">" : "<") + this.selector.getColumnName();
        super.okPressed();
    }

    public String getSortingColumn() {
        return this.sortingColumn;
    }
}

