/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmListFilter
extends ViewerFilter {
    private static final String[] stateText;
    private List<Long> rootObjects = new ArrayList<Long>();
    private int stateFilter = -1;
    private int severityFilter = 255;
    private NXCSession session = ConsoleSharedData.getSession();
    private String filterString = null;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.AlarmListLabelProvider_AlarmState_Outstanding;
        Messages.get();
        stringArray[1] = Messages.AlarmListLabelProvider_AlarmState_Acknowledged;
        Messages.get();
        stringArray[2] = Messages.AlarmListLabelProvider_AlarmState_Resolved;
        Messages.get();
        stringArray[3] = Messages.AlarmListLabelProvider_AlarmState_Terminated;
        stateText = stringArray;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        if (this.checkSeverity(element)) {
            return true;
        }
        if (this.checkState(element)) {
            return true;
        }
        if (this.checkSource(element)) {
            return true;
        }
        if (this.checkMessage(element)) {
            return true;
        }
        if (this.checkCount(element)) {
            return true;
        }
        if (this.checkComments(element)) {
            return true;
        }
        if (this.checkHelpdeskId(element)) {
            return true;
        }
        if (this.checkResolvedBy(element)) {
            return true;
        }
        if (this.checkCreated(element)) {
            return true;
        }
        return this.checkChanged(element);
    }

    private boolean checkSeverity(Object element) {
        return StatusDisplayInfo.getStatusText((Severity)((Alarm)element).getCurrentSeverity()).toLowerCase().contains(this.filterString);
    }

    private boolean checkState(Object element) {
        return stateText[((Alarm)element).getState()].toLowerCase().contains(this.filterString);
    }

    private boolean checkSource(Object element) {
        AbstractObject object = this.session.findObjectById(((Alarm)element).getSourceObjectId());
        return object != null ? object.getObjectName().toLowerCase().contains(this.filterString) : false;
    }

    private boolean checkMessage(Object element) {
        return ((Alarm)element).getMessage().toLowerCase().contains(this.filterString);
    }

    private boolean checkCount(Object element) {
        return Integer.toString(((Alarm)element).getRepeatCount()).contains(this.filterString);
    }

    private boolean checkComments(Object element) {
        return Integer.toString(((Alarm)element).getCommentsCount()).contains(this.filterString);
    }

    private boolean checkHelpdeskId(Object element) {
        switch (((Alarm)element).getHelpdeskState()) {
            case 1: {
                return ((Alarm)element).getHelpdeskReference().toLowerCase().contains(this.filterString);
            }
            case 2: {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(((Alarm)element).getHelpdeskReference()));
                Messages.get();
                return stringBuilder.append(Messages.AlarmListLabelProvider_Closed).toString().toLowerCase().contains(this.filterString);
            }
        }
        return false;
    }

    private boolean checkResolvedBy(Object element) {
        AbstractUserObject user = this.session.findUserDBObjectById((long)((Alarm)element).getAckByUser());
        return user != null ? user.getName().toLowerCase().contains(this.filterString) : false;
    }

    private boolean checkCreated(Object element) {
        return ((Alarm)element).getCreationTime().toLocaleString().contains(this.filterString);
    }

    private boolean checkChanged(Object element) {
        return ((Alarm)element).getLastChangeTime().toLocaleString().contains(this.filterString);
    }

    public boolean filter(Alarm alarm) {
        if (this.stateFilter != -1 && alarm.getState() != this.stateFilter) {
            return false;
        }
        if ((1 << alarm.getCurrentSeverity().getValue() & this.severityFilter) == 0) {
            return false;
        }
        if (this.rootObjects.size() == 0 || this.rootObjects.contains(alarm.getSourceObjectId())) {
            return true;
        }
        AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
        if (object != null) {
            long[] rootObjectsArray = new long[this.rootObjects.size()];
            int i = 0;
            for (long objectId : this.rootObjects) {
                rootObjectsArray[i++] = objectId;
            }
            return object.isChildOf(rootObjectsArray);
        }
        return false;
    }

    public final void setRootObject(long rootObject) {
        this.rootObjects.clear();
        this.rootObjects.add(rootObject);
    }

    public void setRootObjects(List<Long> selectedObjects) {
        this.rootObjects.clear();
        this.rootObjects.addAll(selectedObjects);
    }

    public void setStateFilter(int stateFilter) {
        this.stateFilter = stateFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }
}

