/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import java.io.IOException;

public class DTDParseException
extends IOException {
    public String uriID = "";
    public int lineNumber;
    public int column;

    public DTDParseException() {
        this.lineNumber = -1;
        this.column = -1;
    }

    public DTDParseException(String message2) {
        super(message2);
        this.lineNumber = -1;
        this.column = -1;
    }

    public DTDParseException(String message2, int line, int col) {
        super("At line " + line + ", column " + col + ": " + message2);
        this.lineNumber = line;
        this.column = col;
    }

    public DTDParseException(String id, String message2, int line, int col) {
        super((null != id && id.length() > 0 ? "URI " + id + " at " : "At ") + "line " + line + ", column " + col + ": " + message2);
        if (null != id) {
            this.uriID = id;
        }
        this.lineNumber = line;
        this.column = col;
    }

    public String getId() {
        return this.uriID;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }
}

