/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import org.simpleframework.xml.core.ConstructorCache;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.strategy.Value;

class InstanceFactory {
    private final ConstructorCache cache = new ConstructorCache();

    public Instance getInstance(Value value) {
        return new ValueInstance(value);
    }

    public Instance getInstance(Class type) {
        return new ClassInstance(type);
    }

    private Object getObject(Class type) throws Exception {
        Constructor method = (Constructor)this.cache.get(type);
        if (method == null) {
            method = type.getDeclaredConstructor(new Class[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            this.cache.put(type, method);
        }
        return method.newInstance(new Object[0]);
    }

    private class ClassInstance
    implements Instance {
        private Object value;
        private Class type;

        public ClassInstance(Class type) {
            this.type = type;
        }

        public Object getInstance() throws Exception {
            if (this.value == null) {
                this.value = InstanceFactory.this.getObject(this.type);
            }
            return this.value;
        }

        public Object setInstance(Object value) throws Exception {
            this.value = value;
            return this.value;
        }

        public Class getType() {
            return this.type;
        }

        public boolean isReference() {
            return false;
        }
    }

    private class ValueInstance
    implements Instance {
        private final Value value;
        private final Class type;

        public ValueInstance(Value value) {
            this.type = value.getType();
            this.value = value;
        }

        public Object getInstance() throws Exception {
            if (this.value.isReference()) {
                return this.value.getValue();
            }
            Object object = InstanceFactory.this.getObject(this.type);
            if (this.value != null) {
                this.value.setValue(object);
            }
            return object;
        }

        public Object setInstance(Object object) {
            if (this.value != null) {
                this.value.setValue(object);
            }
            return object;
        }

        public boolean isReference() {
            return this.value.isReference();
        }

        public Class getType() {
            return this.type;
        }
    }
}

