/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;

public class SecurityWarningDialog
extends Dialog {
    public static final int NO = 0;
    public static final int YES = 1;
    public static final int ALWAYS = 2;
    private static final Color BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 242, 177, 0);
    private String message;
    private String details;
    private Button checkDontAskAgain;
    private Font boldFont;
    private boolean dontAskAgain = false;

    public static int showSecurityWarning(Shell parentShell, String message, String details) {
        SecurityWarningDialog dlg = new SecurityWarningDialog(parentShell, message, details);
        if (dlg.open() != 0) {
            return 0;
        }
        return dlg.dontAskAgain ? 2 : 1;
    }

    protected SecurityWarningDialog(Shell parentShell, String message, String details) {
        super(parentShell);
        this.message = message;
        this.details = details;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.SecurityWarningDialog_Title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.YES_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.NO_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        dialogArea.setLayout((Layout)layout);
        Composite topArea = new Composite(dialogArea, 0);
        topArea.setBackground(BACKGROUND_COLOR);
        layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        topArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 500;
        topArea.setLayoutData((Object)gd);
        final Label icon = new Label(topArea, 0);
        icon.setBackground(BACKGROUND_COLOR);
        icon.setImage(Activator.getImageDescriptor("icons/security-warning.png").createImage());
        icon.setLayoutData((Object)new GridData(128, 0x1000000, false, false));
        icon.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                icon.getImage().dispose();
            }
        });
        FontData fd = JFaceResources.getDialogFont().getFontData()[0];
        fd.setStyle(1);
        this.boldFont = new Font((Device)parent.getDisplay(), fd);
        Label text = new Label(topArea, 16448);
        text.setBackground(BACKGROUND_COLOR);
        text.setFont(this.boldFont);
        text.setText(this.message);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SecurityWarningDialog.this.boldFont.dispose();
            }
        });
        Composite bottomArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        bottomArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 500;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        bottomArea.setLayoutData((Object)gd);
        Label detailsText = new Label(bottomArea, 16448);
        detailsText.setText(this.details);
        detailsText.setLayoutData((Object)new GridData(4, 128, true, true));
        this.checkDontAskAgain = new Button(bottomArea, 32);
        Messages.get();
        this.checkDontAskAgain.setText(Messages.SecurityWarningDialog_DontAskAgain);
        return dialogArea;
    }

    protected void okPressed() {
        this.dontAskAgain = this.checkDontAskAgain.getSelection();
        super.okPressed();
    }
}

