/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.dialogs.DCISummaryTableSortColumnSelectionDialog;
import org.netxms.ui.eclipse.dashboard.propertypages.helpers.SortColumnTableLabelProvider;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DciSummaryTableConfig;
import org.netxms.ui.eclipse.datacollection.widgets.SummaryTableSelector;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DciSummaryTable
extends PropertyPage {
    public static final int NAME = 0;
    public static final int ORDER = 1;
    private DciSummaryTableConfig config;
    private List<String> currSortingList;
    private ObjectSelector objectSelector;
    private SummaryTableSelector tableSelector;
    private Spinner refreshInterval;
    private Button checkShowSortAndLimitFields;
    private Spinner numRowsShow;
    private SortableTableViewer sortTables;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private Button buttonUp;
    private Button buttonDown;

    protected Control createContents(Composite parent) {
        this.config = (DciSummaryTableConfig)this.getElement().getAdapter(DciSummaryTableConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        this.currSortingList = this.config.getSortingColumnList();
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.objectSelector.setLabel(Messages.DciSummaryTable_BaseObject);
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getBaseObjectId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        this.tableSelector = new SummaryTableSelector(dialogArea, 0, 8);
        Messages.get();
        this.tableSelector.setLabel(Messages.DciSummaryTable_SummaryTable);
        this.tableSelector.setTableId(this.config.getTableId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.tableSelector.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.refreshInterval = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.DciSummaryTable_RefreshInterval, (int)0, (int)10000, (Object)gd);
        this.refreshInterval.setSelection(this.config.getRefreshInterval());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowSortAndLimitFields = new Button(dialogArea, 32);
        this.checkShowSortAndLimitFields.setText("Show top N nodes");
        this.checkShowSortAndLimitFields.setSelection(this.config.isEnableSortingAndLineLimit());
        this.checkShowSortAndLimitFields.setLayoutData((Object)gd);
        this.checkShowSortAndLimitFields.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DciSummaryTable.this.checkShowSortAndLimitFields.getSelection()) {
                    DciSummaryTable.this.sortTables.setSelection(null);
                    DciSummaryTable.this.buttonAdd.setEnabled(true);
                    DciSummaryTable.this.numRowsShow.setEnabled(true);
                } else {
                    DciSummaryTable.this.buttonUp.setEnabled(false);
                    DciSummaryTable.this.buttonDown.setEnabled(false);
                    DciSummaryTable.this.buttonEdit.setEnabled(false);
                    DciSummaryTable.this.buttonRemove.setEnabled(false);
                    DciSummaryTable.this.buttonAdd.setEnabled(false);
                    DciSummaryTable.this.numRowsShow.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite showTopNNodes = new Composite(dialogArea, 2048);
        layout = new GridLayout();
        showTopNNodes.setLayout((Layout)layout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.numRowsShow = WidgetHelper.createLabeledSpinner((Composite)showTopNNodes, (int)2048, (String)"Number of lines to show", (int)0, (int)10000, (Object)gd);
        this.numRowsShow.setSelection(this.config.getNumRowShown());
        this.numRowsShow.setEnabled(this.config.isEnableSortingAndLineLimit());
        Label label = new Label(showTopNNodes, 0);
        label.setText("Sort by columns");
        String[] columnNames = new String[]{"Name", "Sort order"};
        int[] columnWidths = new int[]{320, 120};
        this.sortTables = new SortableTableViewer(showTopNNodes, columnNames, columnWidths, 0, 0, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        gd.heightHint = 150;
        this.sortTables.getTable().setLayoutData((Object)gd);
        this.sortTables.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sortTables.setLabelProvider((IBaseLabelProvider)new SortColumnTableLabelProvider());
        this.sortTables.setInput(this.currSortingList);
        this.sortTables.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DciSummaryTable.this.checkShowSortAndLimitFields.getSelection()) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    int index = DciSummaryTable.this.currSortingList.indexOf(selection.getFirstElement());
                    DciSummaryTable.this.buttonUp.setEnabled(selection.size() == 1 && index > 0);
                    DciSummaryTable.this.buttonDown.setEnabled(selection.size() == 1 && index >= 0 && index < DciSummaryTable.this.currSortingList.size() - 1);
                    DciSummaryTable.this.buttonEdit.setEnabled(selection.size() == 1);
                    DciSummaryTable.this.buttonRemove.setEnabled(selection.size() > 0);
                } else {
                    DciSummaryTable.this.buttonUp.setEnabled(false);
                    DciSummaryTable.this.buttonDown.setEnabled(false);
                    DciSummaryTable.this.buttonEdit.setEnabled(false);
                    DciSummaryTable.this.buttonRemove.setEnabled(false);
                }
            }
        });
        this.sortTables.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DciSummaryTable.this.buttonEdit.notifyListeners(13, new Event());
            }
        });
        Composite buttons = new Composite(showTopNNodes, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        buttons.setLayoutData((Object)gd);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        this.buttonUp = new Button(buttons, 8);
        this.buttonUp.setText("UP");
        this.buttonUp.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.moveUp();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonUp.setLayoutData((Object)rd);
        this.buttonUp.setEnabled(false);
        this.buttonDown = new Button(buttons, 8);
        this.buttonDown.setText("Down");
        this.buttonDown.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.moveDown();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonDown.setLayoutData((Object)rd);
        this.buttonDown.setEnabled(false);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalIndent = 2;
        buttons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText("Add");
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.add();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonAdd.setEnabled(this.config.isEnableSortingAndLineLimit());
        this.buttonEdit = new Button(buttons, 8);
        this.buttonEdit.setText("Edit");
        this.buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.edit();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonEdit.setEnabled(false);
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText("Delete");
        this.buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.remove();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.buttonRemove.setEnabled(false);
        return dialogArea;
    }

    private void moveUp() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        int index = this.currSortingList.indexOf(element);
        if (index <= 0) {
            return;
        }
        String a = this.currSortingList.get(index - 1);
        this.currSortingList.set(index - 1, this.currSortingList.get(index));
        this.currSortingList.set(index, a);
        this.sortTables.setInput((Object)this.currSortingList.toArray());
        this.sortTables.setSelection((ISelection)selection);
    }

    private void moveDown() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        int index = this.currSortingList.indexOf(element);
        if (index >= this.currSortingList.size() - 1 && index < 0) {
            return;
        }
        String a = this.currSortingList.get(index + 1);
        this.currSortingList.set(index + 1, this.currSortingList.get(index));
        this.currSortingList.set(index, a);
        this.sortTables.setInput((Object)this.currSortingList.toArray());
        this.sortTables.setSelection((ISelection)selection);
    }

    private void add() {
        String s;
        DCISummaryTableSortColumnSelectionDialog dlg = new DCISummaryTableSortColumnSelectionDialog(this.getShell(), null, false, this.tableSelector.getTableId());
        if (dlg.open() == 0 && !this.currSortingList.contains(s = dlg.getSortingColumn())) {
            this.currSortingList.add(s);
            this.sortTables.setInput((Object)this.currSortingList.toArray());
        }
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        DCISummaryTableSortColumnSelectionDialog dlg = new DCISummaryTableSortColumnSelectionDialog(this.getShell(), element.substring(1), element.charAt(0) == '>', this.tableSelector.getTableId());
        if (dlg.open() == 0) {
            String s = dlg.getSortingColumn();
            int index = this.currSortingList.indexOf(element);
            if (index < this.currSortingList.size() && index >= 0) {
                this.currSortingList.set(index, s);
                this.sortTables.setInput((Object)this.currSortingList.toArray());
            }
        }
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        this.currSortingList.remove(element);
        this.sortTables.setInput((Object)this.currSortingList.toArray());
    }

    public boolean performOk() {
        this.config.setBaseObjectId(this.objectSelector.getObjectId());
        this.config.setTableId(this.tableSelector.getTableId());
        this.config.setRefreshInterval(this.refreshInterval.getSelection());
        this.config.setNumRowShown(this.numRowsShow.getSelection());
        this.config.setSortingColumnList(this.currSortingList);
        this.config.setEnableSortingAndLineLimit(this.checkShowSortAndLimitFields.getSelection());
        return true;
    }
}

