/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum NodePollType {
    UNKNOWN(0),
    STATUS(1),
    CONFIGURATION_FULL(2),
    INTERFACES(3),
    TOPOLOGY(4),
    CONFIGURATION_NORMAL(5),
    INSTANCE_DISCOVERY(6);

    private int value;
    private static Map<Integer, NodePollType> lookupTable;

    static {
        lookupTable = new HashMap<Integer, NodePollType>();
        NodePollType[] nodePollTypeArray = NodePollType.values();
        int n = nodePollTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodePollType element = nodePollTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private NodePollType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static NodePollType getByValue(int value) {
        NodePollType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)NodePollType.class.getName(), (String)("Unknown element " + value));
            return UNKNOWN;
        }
        return element;
    }
}

