/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class Comments
extends PropertyPage {
    private AbstractObject object;
    private Text comments;
    private String initialComments;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        this.initialComments = this.object.getComments();
        if (this.initialComments == null) {
            this.initialComments = "";
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.comments = new Text(dialogArea, 2818);
        this.comments.setText(this.initialComments);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.comments.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (this.initialComments.equals(this.comments.getText())) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final String newComments = new String(this.comments.getText());
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.Comments_JobName, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.updateObjectComments(Comments.this.object.getObjectId(), newComments);
                Comments.this.initialComments = newComments;
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Comments_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Comments.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.comments.setText("");
    }
}

