/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objecttools.InputField;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.dialogs.EditInputFieldDialog;
import org.netxms.ui.eclipse.objecttools.propertypages.helpers.InputFieldLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class InputFields
extends PropertyPage {
    private ObjectToolDetails objectTool;
    private List<InputField> fields = new ArrayList<InputField>();
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private Button buttonUp;
    private Button buttonDown;

    public void createControl(Composite parent) {
        this.noDefaultAndApplyButton();
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        this.objectTool = (ObjectToolDetails)this.getElement().getAdapter(ObjectToolDetails.class);
        InputField[] inputFieldArray = this.objectTool.getInputFields();
        int n = inputFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            InputField f = inputFieldArray[n2];
            this.fields.add(new InputField(f));
            ++n2;
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        gd.widthHint = 540;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new InputFieldLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((InputField)e1).getSequence() - ((InputField)e2).getSequence();
            }
        });
        this.setupTableColumns();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)InputFields.this.viewer.getSelection();
                InputFields.this.buttonEdit.setEnabled(selection.size() == 1);
                InputFields.this.buttonRemove.setEnabled(selection.size() > 0);
                InputFields.this.buttonUp.setEnabled(selection.size() == 1);
                InputFields.this.buttonDown.setEnabled(selection.size() == 1);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                InputFields.this.editField();
            }
        });
        this.viewer.setInput((Object)this.fields.toArray());
        Composite buttonsLeft = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalIndent = 2;
        buttonsLeft.setLayoutData((Object)gd);
        this.buttonUp = new Button(buttonsLeft, 8);
        Messages.get();
        this.buttonUp.setText(Messages.InputFields_Up);
        this.buttonUp.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InputFields.this.moveFieldUp();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonUp.setLayoutData((Object)rd);
        this.buttonUp.setEnabled(false);
        this.buttonDown = new Button(buttonsLeft, 8);
        Messages.get();
        this.buttonDown.setText(Messages.InputFields_Down);
        this.buttonDown.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InputFields.this.moveFieldDown();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonDown.setLayoutData((Object)rd);
        this.buttonDown.setEnabled(false);
        Composite buttonsRight = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalIndent = 2;
        buttonsRight.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttonsRight, 8);
        Messages.get();
        this.buttonAdd.setText(Messages.Columns_Add);
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InputFields.this.addField();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonEdit = new Button(buttonsRight, 8);
        Messages.get();
        this.buttonEdit.setText(Messages.Columns_Edit);
        this.buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InputFields.this.editField();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonEdit.setEnabled(false);
        this.buttonRemove = new Button(buttonsRight, 8);
        Messages.get();
        this.buttonRemove.setText(Messages.Columns_Delete);
        this.buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InputFields.this.removeField();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.buttonRemove.setEnabled(false);
        return dialogArea;
    }

    private void setupTableColumns() {
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        column.setText(Messages.InputFields_Name);
        column.setWidth(200);
        column = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        column.setText(Messages.InputFields_Type);
        column.setWidth(90);
        column = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        column.setText(Messages.InputFields_DisplayName);
        column.setWidth(200);
        this.viewer.getTable().setHeaderVisible(true);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InputFieldsPropertyPage");
    }

    private void addField() {
        InputField f = new InputField("Field" + Integer.toString(this.fields.size() + 1));
        EditInputFieldDialog dlg = new EditInputFieldDialog(this.getShell(), true, f);
        if (dlg.open() == 0 && this.nameIsUnique(f.getName())) {
            f.setSequence(this.fields.size());
            this.fields.add(f);
            this.viewer.setInput((Object)this.fields.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)f));
        }
    }

    private boolean nameIsUnique(String name) {
        for (InputField f : this.fields) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    private void editField() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        EditInputFieldDialog dlg = new EditInputFieldDialog(this.getShell(), false, (InputField)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.viewer.update(selection.getFirstElement(), null);
        }
    }

    private void removeField() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.fields.remove(it.next());
        }
        this.viewer.setInput((Object)this.fields.toArray());
    }

    private void moveFieldUp() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InputField f = (InputField)selection.getFirstElement();
        if (f.getSequence() > 0) {
            this.updateSequence(f.getSequence() - 1, 1);
            f.setSequence(f.getSequence() - 1);
            this.viewer.refresh();
        }
    }

    private void moveFieldDown() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InputField f = (InputField)selection.getFirstElement();
        if (f.getSequence() < this.fields.size() - 1) {
            this.updateSequence(f.getSequence() + 1, -1);
            f.setSequence(f.getSequence() + 1);
            this.viewer.refresh();
        }
    }

    private void updateSequence(int curr, int delta) {
        for (InputField f : this.fields) {
            if (f.getSequence() != curr) continue;
            f.setSequence(curr + delta);
            break;
        }
    }

    protected void applyChanges(boolean isApply) {
        this.objectTool.setInputFields(this.fields);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InputFieldsPropertyPage");
        return true;
    }

    public boolean performCancel() {
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InputFieldsPropertyPage");
        return super.performCancel();
    }
}

