/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.NumericTextFieldValidator;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class StatusCalculation
extends PropertyPage {
    private AbstractObject object;
    private NXCObjectModificationData currentState;
    private int calculationMethod;
    private int propagationMethod;
    private Button radioCalcDefault;
    private Button radioCalcMostCritical;
    private Button radioCalcSingle;
    private Button radioCalcMultiple;
    private Button radioPropDefault;
    private Button radioPropUnchanged;
    private Button radioPropFixed;
    private Button radioPropRelative;
    private Button radioPropTranslated;
    private Combo comboFixedStatus;
    private Combo[] comboTranslatedStatus = new Combo[4];
    private Text textRelativeStatus;
    private Text textSingleThreshold;
    private Text[] textThresholds = new Text[4];

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        this.currentState = new NXCObjectModificationData(this.object.getObjectId());
        this.currentState.setStatusCalculationMethod(this.object.getStatusCalculationMethod());
        this.currentState.setStatusPropagationMethod(this.object.getStatusPropagationMethod());
        this.currentState.setFixedPropagatedStatus(this.object.getFixedPropagatedStatus());
        this.currentState.setStatusShift(this.object.getStatusShift());
        this.currentState.setStatusTransformation(this.object.getStatusTransformation());
        this.currentState.setStatusSingleThreshold(this.object.getStatusSingleThreshold());
        this.currentState.setStatusThresholds(this.object.getStatusThresholds());
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.createLeftPanel(dialogArea);
        this.createRightPanel(dialogArea);
        this.changeCalculationMethod(this.object.getStatusCalculationMethod());
        this.changePropagationMethod(this.object.getStatusPropagationMethod());
        this.createCalcSelectionListener(this.radioCalcDefault, 0);
        this.createCalcSelectionListener(this.radioCalcMostCritical, 1);
        this.createCalcSelectionListener(this.radioCalcSingle, 2);
        this.createCalcSelectionListener(this.radioCalcMultiple, 3);
        this.createPropSelectionListener(this.radioPropDefault, 0);
        this.createPropSelectionListener(this.radioPropUnchanged, 1);
        this.createPropSelectionListener(this.radioPropFixed, 2);
        this.createPropSelectionListener(this.radioPropRelative, 3);
        this.createPropSelectionListener(this.radioPropTranslated, 4);
        return dialogArea;
    }

    private void createLeftPanel(Composite parent) {
        Group group = new Group(parent, 0);
        Messages.get();
        group.setText(Messages.StatusCalculation_PropagateAs);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        this.radioPropDefault = new Button((Composite)group, 16);
        Messages.get();
        this.radioPropDefault.setText(Messages.StatusCalculation_Default);
        this.radioPropDefault.setSelection(this.object.getStatusPropagationMethod() == 0);
        this.radioPropUnchanged = new Button((Composite)group, 16);
        Messages.get();
        this.radioPropUnchanged.setText(Messages.StatusCalculation_Unchanged);
        this.radioPropUnchanged.setSelection(this.object.getStatusPropagationMethod() == 1);
        this.radioPropFixed = new Button((Composite)group, 16);
        Messages.get();
        this.radioPropFixed.setText(Messages.StatusCalculation_FixedTo);
        this.radioPropFixed.setSelection(this.object.getStatusPropagationMethod() == 2);
        this.comboFixedStatus = new Combo((Composite)group, 2056);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.comboFixedStatus.setLayoutData((Object)gd);
        int i = 0;
        while (i < 5) {
            this.comboFixedStatus.add(StatusDisplayInfo.getStatusText((int)i));
            ++i;
        }
        this.comboFixedStatus.select(this.object.getFixedPropagatedStatus().getValue());
        this.radioPropRelative = new Button((Composite)group, 16);
        Messages.get();
        this.radioPropRelative.setText(Messages.StatusCalculation_Relative);
        this.radioPropRelative.setSelection(this.object.getStatusPropagationMethod() == 3);
        this.textRelativeStatus = new Text((Composite)group, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.textRelativeStatus.setLayoutData((Object)gd);
        this.textRelativeStatus.setText(Integer.toString(this.object.getStatusShift()));
        this.radioPropTranslated = new Button((Composite)group, 16);
        Messages.get();
        this.radioPropTranslated.setText(Messages.StatusCalculation_SeverityBased);
        this.radioPropTranslated.setSelection(this.object.getStatusPropagationMethod() == 4);
        Composite translationGroup = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        translationGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        translationGroup.setLayoutData((Object)gd);
        int i2 = 0;
        while (i2 < 4) {
            Label label = new Label(translationGroup, 0);
            label.setText(StatusDisplayInfo.getStatusText((int)(i2 + 1)));
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            label.setLayoutData((Object)gd);
            label = new Label(translationGroup, 0);
            label.setText("->");
            gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            label.setLayoutData((Object)gd);
            this.comboTranslatedStatus[i2] = new Combo(translationGroup, 2056);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.comboTranslatedStatus[i2].setLayoutData((Object)gd);
            int j = 0;
            while (j < 5) {
                this.comboTranslatedStatus[i2].add(StatusDisplayInfo.getStatusText((int)j));
                ++j;
            }
            this.comboTranslatedStatus[i2].select(this.object.getStatusTransformation()[i2].getValue());
            ++i2;
        }
    }

    private void createRightPanel(Composite parent) {
        Group group = new Group(parent, 0);
        Messages.get();
        group.setText(Messages.StatusCalculation_CalculateAs);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        this.radioCalcDefault = new Button((Composite)group, 16);
        Messages.get();
        this.radioCalcDefault.setText(Messages.StatusCalculation_Default2);
        this.radioCalcDefault.setSelection(this.object.getStatusCalculationMethod() == 0);
        this.radioCalcMostCritical = new Button((Composite)group, 16);
        Messages.get();
        this.radioCalcMostCritical.setText(Messages.StatusCalculation_MostCritical);
        this.radioCalcMostCritical.setSelection(this.object.getStatusCalculationMethod() == 1);
        this.radioCalcSingle = new Button((Composite)group, 16);
        Messages.get();
        this.radioCalcSingle.setText(Messages.StatusCalculation_SingleThreshold);
        this.radioCalcSingle.setSelection(this.object.getStatusCalculationMethod() == 2);
        this.textSingleThreshold = new Text((Composite)group, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.textSingleThreshold.setLayoutData((Object)gd);
        this.textSingleThreshold.setText(Integer.toString(this.object.getStatusSingleThreshold()));
        this.radioCalcMultiple = new Button((Composite)group, 16);
        Messages.get();
        this.radioCalcMultiple.setText(Messages.StatusCalculation_MultipleThresholds);
        this.radioCalcMultiple.setSelection(this.object.getStatusCalculationMethod() == 3);
        Composite thresholdGroup = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        thresholdGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        thresholdGroup.setLayoutData((Object)gd);
        int i = 0;
        while (i < 4) {
            Label label = new Label(thresholdGroup, 0);
            label.setText(StatusDisplayInfo.getStatusText((int)(i + 1)));
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            label.setLayoutData((Object)gd);
            this.textThresholds[i] = new Text(thresholdGroup, 2048);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.textThresholds[i].setLayoutData((Object)gd);
            this.textThresholds[i].setText(Integer.toString(this.object.getStatusThresholds()[i]));
            ++i;
        }
    }

    private void changeCalculationMethod(int method) {
        this.calculationMethod = method;
        this.textSingleThreshold.setEnabled(method == 2);
        int i = 0;
        while (i < 4) {
            this.textThresholds[i].setEnabled(method == 3);
            ++i;
        }
    }

    private void changePropagationMethod(int method) {
        this.propagationMethod = method;
        this.comboFixedStatus.setEnabled(method == 2);
        this.textRelativeStatus.setEnabled(method == 3);
        int i = 0;
        while (i < 4) {
            this.comboTranslatedStatus[i].setEnabled(method == 4);
            ++i;
        }
    }

    private void createCalcSelectionListener(Button button, final int newMethod) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatusCalculation.this.changeCalculationMethod(newMethod);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createPropSelectionListener(Button button, final int newMethod) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatusCalculation.this.changePropagationMethod(newMethod);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void performDefaults() {
        super.performDefaults();
        this.radioCalcDefault.setSelection(true);
        this.radioCalcMostCritical.setSelection(false);
        this.radioCalcMultiple.setSelection(false);
        this.radioCalcSingle.setSelection(false);
        this.radioPropDefault.setSelection(true);
        this.radioPropFixed.setSelection(false);
        this.radioPropRelative.setSelection(false);
        this.radioPropTranslated.setSelection(false);
        this.radioPropUnchanged.setSelection(false);
        this.changeCalculationMethod(0);
        this.changePropagationMethod(0);
    }

    private boolean hasChanges(NXCObjectModificationData md) {
        if (this.currentState.getStatusCalculationMethod() != md.getStatusCalculationMethod() || this.currentState.getStatusPropagationMethod() != md.getStatusPropagationMethod()) {
            return true;
        }
        switch (md.getStatusCalculationMethod()) {
            case 2: {
                if (this.currentState.getStatusSingleThreshold() == md.getStatusSingleThreshold()) break;
                return true;
            }
            case 3: {
                if (Arrays.equals(this.currentState.getStatusThresholds(), md.getStatusThresholds())) break;
                return true;
            }
        }
        switch (md.getStatusPropagationMethod()) {
            case 2: {
                if (this.currentState.getFixedPropagatedStatus() == md.getFixedPropagatedStatus()) break;
                return true;
            }
            case 3: {
                if (this.currentState.getStatusShift() == md.getStatusShift()) break;
                return true;
            }
            case 4: {
                if (Arrays.equals(this.currentState.getStatusTransformation(), md.getStatusTransformation())) break;
                return true;
            }
        }
        return false;
    }

    protected boolean applyChanges(final boolean isApply) {
        block8: {
            block7: {
                Messages.get();
                if (!WidgetHelper.validateTextInput((Text)this.textRelativeStatus, (String)Messages.StatusCalculation_Validate_RelativeStatus, (TextFieldValidator)new NumericTextFieldValidator(-4L, 4L), (PropertyPage)this)) break block7;
                Messages.get();
                if (!WidgetHelper.validateTextInput((Text)this.textSingleThreshold, (String)Messages.StatusCalculation_Validate_SingleThreshold, (TextFieldValidator)new NumericTextFieldValidator(0L, 100L), (PropertyPage)this)) break block7;
                Text text = this.textThresholds[0];
                Messages.get();
                if (!WidgetHelper.validateTextInput((Text)text, (String)String.format(Messages.StatusCalculation_Validate_Threshold, StatusDisplayInfo.getStatusText((Severity)Severity.WARNING)), (TextFieldValidator)new NumericTextFieldValidator(0L, 100L), (PropertyPage)this)) break block7;
                Text text2 = this.textThresholds[1];
                Messages.get();
                if (!WidgetHelper.validateTextInput((Text)text2, (String)String.format(Messages.StatusCalculation_Validate_Threshold, StatusDisplayInfo.getStatusText((Severity)Severity.MINOR)), (TextFieldValidator)new NumericTextFieldValidator(0L, 100L), (PropertyPage)this)) break block7;
                Text text3 = this.textThresholds[2];
                Messages.get();
                if (!WidgetHelper.validateTextInput((Text)text3, (String)String.format(Messages.StatusCalculation_Validate_Threshold, StatusDisplayInfo.getStatusText((Severity)Severity.MAJOR)), (TextFieldValidator)new NumericTextFieldValidator(0L, 100L), (PropertyPage)this)) break block7;
                Text text4 = this.textThresholds[3];
                Messages.get();
                if (WidgetHelper.validateTextInput((Text)text4, (String)String.format(Messages.StatusCalculation_Validate_Threshold, StatusDisplayInfo.getStatusText((Severity)Severity.CRITICAL)), (TextFieldValidator)new NumericTextFieldValidator(0L, 100L), (PropertyPage)this)) break block8;
            }
            return false;
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setStatusCalculationMethod(this.calculationMethod);
        md.setStatusPropagationMethod(this.propagationMethod);
        md.setFixedPropagatedStatus(ObjectStatus.getByValue((int)this.comboFixedStatus.getSelectionIndex()));
        md.setStatusShift(Integer.parseInt(this.textRelativeStatus.getText()));
        ObjectStatus[] transformations = new ObjectStatus[4];
        int i = 0;
        while (i < 4) {
            transformations[i] = ObjectStatus.getByValue((int)this.comboTranslatedStatus[i].getSelectionIndex());
            ++i;
        }
        md.setStatusTransformation(transformations);
        md.setStatusSingleThreshold(Integer.parseInt(this.textSingleThreshold.getText()));
        int[] thresholds = new int[4];
        int i2 = 0;
        while (i2 < 4) {
            thresholds[i2] = Integer.parseInt(this.textThresholds[i2].getText());
            ++i2;
        }
        md.setStatusThresholds(thresholds);
        if (!this.hasChanges(md)) {
            return true;
        }
        this.currentState = md;
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.StatusCalculation_JobName, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.StatusCalculation_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            StatusCalculation.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

